--------------------------------------------------------------------
--       Actel a54sxa Vital Library
--       NAME: a54sxa.vhd
--       DATE: March 28, 2006
---------------------------------------------------------------------/

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.VITAL_Timing.all;

package COMPONENTS is

constant DefaultTimingChecksOn : Boolean := True;
constant DefaultXGenerationOn : Boolean := False;
constant DefaultXon : Boolean := False;
constant DefaultMsgOn : Boolean := True;



------ Component AND2 ------
 component AND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND2A ------
 component AND2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND2B ------
 component AND2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3 ------
 component AND3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3A ------
 component AND3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3B ------
 component AND3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3C ------
 component AND3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND4 ------
 component AND4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND4A ------
 component AND4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND4B ------
 component AND4B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND4C ------
 component AND4C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND4D ------
 component AND4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND5A ------
 component AND5A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND5B ------
 component AND5B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND5C ------
 component AND5C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1 ------
 component AO1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO10 ------
 component AO10
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO11 ------
 component AO11
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO12 ------
 component AO12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO13 ------
 component AO13
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO14 ------
 component AO14
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO15 ------
 component AO15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO16 ------
 component AO16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO17 ------
 component AO17
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO18 ------
 component AO18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1A ------
 component AO1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1B ------
 component AO1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1C ------
 component AO1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1D ------
 component AO1D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1E ------
 component AO1E
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2 ------
 component AO2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2A ------
 component AO2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2B ------
 component AO2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2C ------
 component AO2C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2D ------
 component AO2D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2E ------
 component AO2E
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO3 ------
 component AO3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO3A ------
 component AO3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO3B ------
 component AO3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO3C ------
 component AO3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO4A ------
 component AO4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO5A ------
 component AO5A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO6 ------
 component AO6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO6A ------
 component AO6A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO7 ------
 component AO7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO8 ------
 component AO8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO9 ------
 component AO9
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1 ------
 component AOI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1A ------
 component AOI1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1B ------
 component AOI1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1C ------
 component AOI1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1D ------
 component AOI1D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI2A ------
 component AOI2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI2B ------
 component AOI2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI3A ------
 component AOI3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI4 ------
 component AOI4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI4A ------
 component AOI4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI5 ------
 component AOI5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1 ------
 component AX1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1A ------
 component AX1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1B ------
 component AX1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1C ------
 component AX1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1D ------
 component AX1D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1E ------
 component AX1E
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO1 ------
 component AXO1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO2 ------
 component AXO2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO3 ------
 component AXO3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO5 ------
 component AXO5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO6 ------
 component AXO6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO7 ------
 component AXO7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI1 ------
 component AXOI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI2 ------
 component AXOI2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI3 ------
 component AXOI3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI4 ------
 component AXOI4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI5 ------
 component AXOI5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI7 ------
 component AXOI7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF ------
 component BIBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.000 ns, 0.000 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BUFA ------
 component BUFA
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BUFD ------
 component BUFD
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BUFF ------
 component BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF ------
 component CLKBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUFI ------
 component CLKBUFI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKINT ------
 component CLKINT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKINTI ------
 component CLKINTI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CM7 ------
 component CM7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S0		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CM8 ------
 component CM8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CM8INV ------
 component CM8INV
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMA9 ------
 component CMA9
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMAF ------
 component CMAF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMB3 ------
 component CMB3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMB7 ------
 component CMB7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMBB ------
 component CMBB
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMBF ------
 component CMBF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMEA ------
 component CMEA
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMEB ------
 component CMEB
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMEE ------
 component CMEE
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMEF ------
 component CMEF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF1 ------
 component CMF1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF2 ------
 component CMF2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF3 ------
 component CMF3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF4 ------
 component CMF4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF5 ------
 component CMF5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF6 ------
 component CMF6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF7 ------
 component CMF7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF8 ------
 component CMF8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF9 ------
 component CMF9
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMFA ------
 component CMFA
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMFB ------
 component CMFB
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMFC ------
 component CMFC
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMFD ------
 component CMFD
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMFE ------
 component CMFE
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CS1 ------
 component CS1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CS2 ------
 component CS2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CY2A ------
 component CY2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B0		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A1		: in    STD_ULOGIC;
		B1		: in    STD_ULOGIC;
		A0		: in    STD_ULOGIC;
		B0		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CY2B ------
 component CY2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B0		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A1		: in    STD_ULOGIC;
		B1		: in    STD_ULOGIC;
		A0		: in    STD_ULOGIC;
		B0		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component DF1 ------
 component DF1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DF1_CC ------
 component DF1_CC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DF1B ------
 component DF1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFC1B ------
 component DFC1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFC1B_CC ------
 component DFC1B_CC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFC1D ------
 component DFC1D
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE1B ------
 component DFE1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE1C ------
 component DFE1C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE3C ------
 component DFE3C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE3D ------
 component DFE3D
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE4F ------
 component DFE4F
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE4G ------
 component DFE4G
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFEG ------
 component DFEG
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFEH ------
 component DFEH
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFP1 ------
 component DFP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFP1A ------
 component DFP1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFP1B ------
 component DFP1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFP1B_CC ------
 component DFP1B_CC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFP1D ------
 component DFP1D
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFPC ------
 component DFPC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFPCB ------
 component DFPCB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFPCC ------
 component DFPCC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DL1 ------
 component DL1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DL1B ------
 component DL1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DL2A ------
 component DL2A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DL2C ------
 component DL2C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLC ------
 component DLC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLC1 ------
 component DLC1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLC1A ------
 component DLC1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLCA ------
 component DLCA
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLE2C ------
 component DLE2C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLE3B ------
 component DLE3B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLE3C ------
 component DLE3C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLP1 ------
 component DLP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLP1A ------
 component DLP1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLP1B ------
 component DLP1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLP1C ------
 component DLP1C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component FA1 ------
 component FA1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CI_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CI_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CI		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		CI		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component GAND2 ------
 component GAND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GMX4 ------
 component GMX4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S0		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GNAND2 ------
 component GNAND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GND ------
 component GND
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 end component;


------ Component GNOR2 ------
 component GNOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GOR2 ------
 component GOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GXOR2 ------
 component GXOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HA1 ------
 component HA1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component HA1A ------
 component HA1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component HA1B ------
 component HA1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component HA1C ------
 component HA1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF ------
 component HCLKBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF ------
 component INBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INV ------
 component INV
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INVA ------
 component INVA
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INVD ------
 component INVD
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component JKF ------
 component JKF
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component JKF1B ------
 component JKF1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component JKF2A ------
 component JKF2A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tipd_CLR	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLR	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component JKF2B ------
 component JKF2B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge           :   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tipd_CLR	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLR	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component JKF3A ------
 component JKF3A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge   	:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        PRE	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component JKF3B ------
 component JKF3B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge   	:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        PRE	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component MAJ3 ------
 component MAJ3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MAJ3X ------
 component MAJ3X
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MAJ3XI ------
 component MAJ3XI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MIN3 ------
 component MIN3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MIN3X ------
 component MIN3X
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MIN3XI ------
 component MIN3XI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2 ------
 component MX2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2A ------
 component MX2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2B ------
 component MX2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2C ------
 component MX2C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX4 ------
 component MX4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S0		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S1		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2 ------
 component NAND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2A ------
 component NAND2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2B ------
 component NAND2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3 ------
 component NAND3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3A ------
 component NAND3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3B ------
 component NAND3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3C ------
 component NAND3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND4 ------
 component NAND4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND4A ------
 component NAND4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND4B ------
 component NAND4B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND4C ------
 component NAND4C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND4D ------
 component NAND4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND5B ------
 component NAND5B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND5C ------
 component NAND5C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2 ------
 component NOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2A ------
 component NOR2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2B ------
 component NOR2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3 ------
 component NOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3A ------
 component NOR3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3B ------
 component NOR3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3C ------
 component NOR3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR4 ------
 component NOR4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR4A ------
 component NOR4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR4B ------
 component NOR4B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR4C ------
 component NOR4C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR4D ------
 component NOR4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR5B ------
 component NOR5B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR5C ------
 component NOR5C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1 ------
 component OA1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1A ------
 component OA1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1B ------
 component OA1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1C ------
 component OA1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA2 ------
 component OA2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA2A ------
 component OA2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA3 ------
 component OA3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA3A ------
 component OA3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA3B ------
 component OA3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA4 ------
 component OA4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA4A ------
 component OA4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA5 ------
 component OA5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI1 ------
 component OAI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI2A ------
 component OAI2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI3 ------
 component OAI3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI3A ------
 component OAI3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR2 ------
 component OR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR2A ------
 component OR2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR2B ------
 component OR2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3 ------
 component OR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3A ------
 component OR3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3B ------
 component OR3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3C ------
 component OR3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR4 ------
 component OR4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR4A ------
 component OR4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR4B ------
 component OR4B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR4C ------
 component OR4C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR4D ------
 component OR4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR5A ------
 component OR5A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR5B ------
 component OR5B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR5C ------
 component OR5C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF ------
 component OUTBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TF1A ------
 component TF1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_T_CLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_T_CLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_T_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_T_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge	:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tipd_CLK	:  VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_T	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		T	:  in    STD_ULOGIC;
		CLR	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component TF1B ------
 component TF1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_T_CLK_negedge_negedge	:   VitalDelayType := 0.000 ns;
		thold_T_CLK_negedge_negedge	:   VitalDelayType := 0.000 ns;
		tsetup_T_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		thold_T_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge	:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge	:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge	:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tipd_CLK	:  VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_T	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		T	:  in    STD_ULOGIC;
		CLR	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component TRIBUFF ------
 component TRIBUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.000 ns, 0.000 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component VCC ------
 component VCC
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1 ------
 component XA1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1A ------
 component XA1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1B ------
 component XA1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1C ------
 component XA1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XAI1 ------
 component XAI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XAI1A ------
 component XAI1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XNOR2 ------
 component XNOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XNOR3 ------
 component XNOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XO1 ------
 component XO1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XO1A ------
 component XO1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XOR2 ------
 component XOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XOR3 ------
 component XOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component ZOR3 ------
 component ZOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component ZOR3I ------
 component ZOR3I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBIBUF ------
 component CLKBIBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.000 ns, 0.000 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBIBUFI ------
 component CLKBIBUFI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.000 ns, 0.000 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component QCLKBIBUF ------
 component QCLKBIBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.000 ns, 0.000 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component QCLKBIBUFI ------
 component QCLKBIBUFI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.000 ns, 0.000 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component QCLKBUF ------
 component QCLKBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component QCLKBUFI ------
 component QCLKBUFI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component QCLKINT ------
 component QCLKINT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component QCLKINTI ------
 component QCLKINTI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;

  component CM8F
     generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S11_Y                      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S10_Y                      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S01_Y                      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S00_Y                      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D3_Y                       :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D2_Y                       :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D1_Y                       :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D0_Y                       :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S11_FY                     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S10_FY                     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S01_FY                     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S00_FY                     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D3_FY                      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D2_FY                      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D1_FY                      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D0_FY                      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_D0                        :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D1                        :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D2                        :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D3                        :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S00                       :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S01                       :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S10                       :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S11                       :  VitalDelayType01 := (0.000 ns, 0.000 ns));


   port(
      D0                             :  in    STD_ULOGIC;
      D1                             :  in    STD_ULOGIC;
      D2                             :  in    STD_ULOGIC;
      D3                             :  in    STD_ULOGIC;
      S00                            :  in    STD_ULOGIC;
      S01                            :  in    STD_ULOGIC;
      S10                            :  in    STD_ULOGIC;
      S11                            :  in    STD_ULOGIC;
      FY                             :  out   STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);
 end component;

  component FA1A
     generic(
                TimingChecksOn:Boolean :=True;
                Xon: Boolean :=False;
                InstancePath: STRING :="*";
                MsgOn: Boolean :=True;
                tpd_CI_CO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_CO                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A_CO                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CI_S                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_CI         : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_B          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_A          : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                CI              : in    STD_ULOGIC;
                B               : in    STD_ULOGIC;
                A               : in    STD_ULOGIC;
                CO              : out    STD_ULOGIC;
                S               : out    STD_ULOGIC);
 end component;

 component FA1B
   generic(
                TimingChecksOn:Boolean :=True;
                Xon: Boolean :=False;
                InstancePath: STRING :="*";
                MsgOn: Boolean :=True;
                tpd_A_CO                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_CO                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CI_CO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CI_S                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_A          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_B          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CI         : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                A               : in    STD_ULOGIC;
                B               : in    STD_ULOGIC;
                CI              : in    STD_ULOGIC;
                CO              : out    STD_ULOGIC;
                S               : out    STD_ULOGIC);
  end component;

 component FA2A
   generic(
                TimingChecksOn:Boolean :=True;
                Xon: Boolean :=False;
                InstancePath: STRING :="*";
                MsgOn: Boolean :=True;
                tpd_CI_CO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_CO                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A0_CO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A1_CO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A0_S                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A1_S                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CI_S                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_CI         : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_B          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_A0         : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_A1         : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                CI              : in    STD_ULOGIC;
                B               : in    STD_ULOGIC;
                A0              : in    STD_ULOGIC;
                A1              : in    STD_ULOGIC;
                CO              : out    STD_ULOGIC;
                S               : out    STD_ULOGIC);
 end component;


end COMPONENTS;

--------------------- END OF COMPONENTS PACKAGE SECTION  ----------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;

use IEEE.VITAL_Timing.all;
use IEEE.VITAL_Primitives.all;

package VTABLES is

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

-- CLR_ipd, CLK_delayed, Q_zd, D, E_delayed, PRE_ipd, CLK_ipd
CONSTANT DFEG_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  x,  x,  L ),  -- output 0; clear is active
( H,  x,  x,  x,  x,  L,  x,  x,  H ),  -- output 1; preset is active

( H,  L,  x,  H,  L,  x,  H,  x,  H ),  -- output 1; rising edge CLK, PRE=x, Q_old=x, D=1, E=0 (Q follows D)
( x,  L,  x,  L,  L,  H,  H,  x,  L ),  -- output 0; rising edge CLK, CLR=x, Q_old=x, D=0, E=0 (Q follows D)

( H,  H,  x,  x,  x,  H,  x,  x,  S ),  -- output steady; potential falling edge of CLK, CLR=PRE=1
( H,  x,  x,  x,  x,  H,  L,  x,  S ),  -- output steady; potential falling edge of CLK, CLR=PRE=1

( H,  x,  H,  H,  x,  x,  H,  x,  H ),  -- output 1; potential rising edge CLK, PRE=x, Q_old=1, D=1, E=x
( H,  L,  H,  H,  x,  x,  x,  x,  H ),  -- output 1; potential rising edge CLK, PRE=x, Q_old=1, D=1, E=x
( H,  x,  H,  x,  H,  x,  H,  x,  H ),  -- output 1; potential rising edge CLK, PRE=x, Q_old=1, D=x, E=1
( H,  L,  H,  x,  H,  x,  x,  x,  H ),  -- output 1; potential rising edge CLK, PRE=x, Q_old=1, D=x, E=1

( x,  x,  L,  L,  x,  H,  H,  x,  L ),  -- output 0; potential rising edge CLK, CLR=x, Q_old=0, D=0, E=x
( x,  L,  L,  L,  x,  H,  x,  x,  L ),  -- output 0; potential rising edge CLK, CLR=x, Q_old=0, D=0, E=x
( x,  x,  L,  x,  H,  H,  H,  x,  L ),  -- output 0; potential rising edge CLK, CLR=x, Q_old=0, D=x, E=1
( x,  L,  L,  x,  H,  H,  x,  x,  L ),  -- output 0; potential rising edge CLK, CLR=x, Q_old=0, D=x, E=1

( U,  H,  L,  x,  x,  H,  x,  x,  L ),  -- output 0; potential falling edge CLK, CLR=U, Q_old=0, D=x, E=x
( U,  x,  L,  x,  x,  H,  L,  x,  L ),  -- output 0; potential falling edge CLK, CLR=U, Q_old=0, D=x, E=x
( H,  H,  H,  x,  x,  U,  x,  x,  H ),  -- output 1; potential falling edge CLK, PRE=U, Q_old=1, D=x, E=x
( H,  x,  H,  x,  x,  U,  L,  x,  H )); -- output 1; potential falling edge CLK, PRE=U, Q_old=1, D=x, E=x

-- CLR_ipd, CLK_delayed, T_delayed, Q_zd, CLK_ipd
CONSTANT tflipflop_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  L ),
( H,  L,  L,  H,  H,  x,  H ),
( H,  L,  H,  L,  H,  x,  H ),
( H,  H,  x,  x,  x,  x,  S ),
( H,  x,  x,  x,  L,  x,  S ),
( x,  L,  L,  L,  H,  x,  L ),
( x,  L,  H,  H,  H,  x,  L ));

-- CLR_ipd, CLK_delayed, PRE_delayed,K_delayed,J_delayed, Q_zd, CLK_ipd
CONSTANT jkflipflop_Q_tab : VitalStateTableType := (
( L,  x,  H,  x,  x,  x,  x,  x,  U ),
( L,  x,  L,  x,  x,  x,  x,  x,  L ),
( H,  L,  x,  L,  H,  x,  H,  x,  H ),
( H,  L,  x,  L,  x,  H,  H,  x,  H ),
( H,  L,  x,  x,  H,  L,  H,  x,  H ),
( H,  H,  L,  x,  x,  x,  x,  x,  S ),
( H,  x,  L,  x,  x,  x,  L,  x,  S ),
( H,  x,  H,  x,  x,  x,  x,  x,  H ),
( x,  L,  L,  H,  L,  x,  H,  x,  L ),
( x,  L,  L,  H,  x,  H,  H,  x,  L ),
( x,  L,  L,  x,  L,  L,  H,  x,  L ),
( U,  x,  L,  x,  x,  L,  x,  x,  L ),
( H,  x,  U,  x,  x,  H,  x,  x,  H ));

CONSTANT JKF2A_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  x,  L ),
( H,  L,  L,  H,  x,  H,  x,  H ),
( H,  L,  L,  x,  H,  H,  x,  H ),
( H,  L,  x,  H,  L,  H,  x,  H ),
( H,  H,  x,  x,  x,  x,  x,  S ),
( H,  x,  x,  x,  x,  L,  x,  S ),
( x,  L,  H,  L,  x,  H,  x,  L ),
( x,  L,  H,  x,  H,  H,  x,  L ),
( x,  L,  x,  L,  L,  H,  x,  L ),
( U,  x,  x,  x,  L,  x,  x,  L ));

CONSTANT JKF3A_Q_tab : VitalStateTableType := (
( L,  H,  L,  x,  H,  H,  x,  L ),
( L,  H,  x,  H,  H,  H,  x,  L ),
( L,  L,  H,  x,  x,  H,  x,  H ),
( L,  L,  x,  H,  x,  H,  x,  H ),
( L,  x,  L,  L,  H,  H,  x,  L ),
( L,  x,  H,  L,  x,  H,  x,  H ),
( H,  x,  x,  x,  H,  x,  x,  S ),
( x,  x,  x,  x,  L,  x,  x,  H ),
( x,  x,  x,  x,  H,  L,  x,  S ),
( x,  x,  x,  H,  U,  x,  x,  H ));


CONSTANT dlatch_DLE3B_Q_tab : VitalStateTableType := (
( x,  x,  x,  H,  x,  H ),   --active high preset

( H,  x,  x,  L,  x,  S ),   --latch
( x,  H,  x,  L,  x,  S ),   --latch

( L,  L,  H,  L,  x,  H ),   --transparent
( L,  L,  L,  L,  x,  L ),   --transparent

( U,  x,  H,  L,  H,  H ),   --o/p mux pessimism
( x,  U,  H,  L,  H,  H ),   --o/p mux pessimism
( U,  x,  L,  L,  L,  L ),   --o/p mux pessimism
( x,  U,  L,  L,  L,  L ),   --o/p mux pessimism

( L,  L,  H,  U,  x,  H ),   --PRE==X
( H,  x,  x,  U,  H,  H ),   --PRE==X
( x,  H,  x,  U,  H,  H ),   --PRE==X
( L,  U,  H,  U,  H,  H ),   --PRE==X
( U,  L,  H,  U,  H,  H ),   --PRE==X
( U,  U,  H,  U,  H,  H ));  --PRE==X
--G, E, D, P, Qn, Qn+1

CONSTANT dlatch_DLE2B_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  L ),   --active low clear

( H,  H,  x,  x,  x,  S ),   --latch
( H,  x,  H,  x,  x,  S ),   --latch

( H,  L,  L,  H,  x,  H ),   --transparent
( H,  L,  L,  L,  x,  L ),   --transparent

( H,  x,  x,  L,  L,  L ),   --o/p mux pessimism
( H,  x,  x,  H,  H,  H ),   --o/p mux pessimism

( U,  x,  x,  L,  L,  L ),   --CLR==X, o/p mux pessimism
( U,  H,  x,  x,  L,  L ),   --CLR==X, o/p mux pessimism, latch
( U,  x,  H,  x,  L,  L ),   --CLR==X, o/p mux pessimism, latch
( U,  L,  L,  L,  x,  L ));  --CLR==X, i/p mux pessimism
--C, G, E, D, Qn, Qn+1


CONSTANT dlatch_DL2C_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  L ),   --active low clear
( H,  x,  x,  H,  x,  H ),   --active high preset

( H,  H,  x,  L,  x,  S ),   --latch
( H,  L,  L,  L,  x,  L ),   --transparent

( U,  L,  L,  L,  x,  L ),   --CLR==U
( U,  H,  x,  L,  L,  L ),   --CLR==U
( x,  U,  L,  L,  L,  L ),   --CLR,G==U

( H,  U,  H,  x,  H,  H ),   --PRE==U/x,G==U
( H,  L,  H,  x,  x,  H ),   --PRE==U/x
( H,  H,  x,  U,  H,  H ));  --PRE==U
--CLR, G, D, PRE, Qn, Qn+1

CONSTANT DL2A_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  L ),
( H,  H,  x,  H,  x,  H ),
( H,  x,  L,  L,  x,  S ),
( H,  H,  L,  x,  H,  H ),
( H,  H,  U,  U,  H,  H ),
( H,  L,  L,  x,  L,  L ),
( H,  L,  L,  H,  x,  L ),
( H,  x,  H,  x,  x,  H ),
( H,  x,  U,  L,  H,  H ),
( x,  L,  L,  x,  L,  L ),
( U,  x,  L,  L,  L,  L ),
( U,  L,  L,  H,  x,  L ));

end VTABLES;



--------------------- END OF VTABLE TABLE SECTION  ----------------



 ---- CELL AND2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2 :  entity is TRUE;
 end AND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( A_ipd  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2_VITAL of AND2 is 
    for VITAL_ACT
    end for;
 end CFG_AND2_VITAL;



 ---- CELL AND2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2A :  entity is TRUE;
 end AND2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( (NOT A_ipd)  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2A_VITAL of AND2A is 
    for VITAL_ACT
    end for;
 end CFG_AND2A_VITAL;



 ---- CELL AND2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2B :  entity is TRUE;
 end AND2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( (NOT A_ipd)  AND  (NOT B_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2B_VITAL of AND2B is 
    for VITAL_ACT
    end for;
 end CFG_AND2B_VITAL;



 ---- CELL AND3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3 :  entity is TRUE;
 end AND3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3_VITAL of AND3 is 
    for VITAL_ACT
    end for;
 end CFG_AND3_VITAL;



 ---- CELL AND3A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3A :  entity is TRUE;
 end AND3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND3A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3A_VITAL of AND3A is 
    for VITAL_ACT
    end for;
 end CFG_AND3A_VITAL;



 ---- CELL AND3B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3B :  entity is TRUE;
 end AND3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND3B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3B_VITAL of AND3B is 
    for VITAL_ACT
    end for;
 end CFG_AND3B_VITAL;



 ---- CELL AND3C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3C :  entity is TRUE;
 end AND3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND3C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3C_VITAL of AND3C is 
    for VITAL_ACT
    end for;
 end CFG_AND3C_VITAL;



 ---- CELL AND4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND4 :  entity is TRUE;
 end AND4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) AND  C_ipd ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND4_VITAL of AND4 is 
    for VITAL_ACT
    end for;
 end CFG_AND4_VITAL;



 ---- CELL AND4A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND4A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND4A :  entity is TRUE;
 end AND4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND4A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND4A_VITAL of AND4A is 
    for VITAL_ACT
    end for;
 end CFG_AND4A_VITAL;



 ---- CELL AND4B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND4B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND4B :  entity is TRUE;
 end AND4B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND4B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND4B_VITAL of AND4B is 
    for VITAL_ACT
    end for;
 end CFG_AND4B_VITAL;



 ---- CELL AND4C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND4C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND4C :  entity is TRUE;
 end AND4C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND4C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND4C_VITAL of AND4C is 
    for VITAL_ACT
    end for;
 end CFG_AND4C_VITAL;



 ---- CELL AND4D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND4D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND4D :  entity is TRUE;
 end AND4D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND4D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) AND  (NOT D_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND4D_VITAL of AND4D is 
    for VITAL_ACT
    end for;
 end CFG_AND4D_VITAL;



 ---- CELL AND5A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND5A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND5A :  entity is TRUE;
 end AND5A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND5A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (((( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd ) AND  D_ipd ) AND  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND5A_VITAL of AND5A is 
    for VITAL_ACT
    end for;
 end CFG_AND5A_VITAL;



 ---- CELL AND5B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND5B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND5B :  entity is TRUE;
 end AND5B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND5B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd ) AND  D_ipd ) AND  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND5B_VITAL of AND5B is 
    for VITAL_ACT
    end for;
 end CFG_AND5B_VITAL;



 ---- CELL AND5C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND5C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND5C :  entity is TRUE;
 end AND5C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AND5C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) AND  D_ipd ) AND  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND5C_VITAL of AND5C is 
    for VITAL_ACT
    end for;
 end CFG_AND5C_VITAL;



 ---- CELL AO1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1 :  entity is TRUE;
 end AO1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1_VITAL of AO1 is 
    for VITAL_ACT
    end for;
 end CFG_AO1_VITAL;



 ---- CELL AO10 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO10 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO10 :  entity is TRUE;
 end AO10;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO10 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) OR  C_ipd ) AND ( D_ipd  OR  E_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO10_VITAL of AO10 is 
    for VITAL_ACT
    end for;
 end CFG_AO10_VITAL;



 ---- CELL AO11 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO11 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO11 :  entity is TRUE;
 end AO11;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO11 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR (( A_ipd  OR  B_ipd ) AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO11_VITAL of AO11 is 
    for VITAL_ACT
    end for;
 end CFG_AO11_VITAL;



 ---- CELL AO12 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO12 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO12 :  entity is TRUE;
 end AO12;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO12 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2( B_ipd ,( A_ipd  AND  (NOT B_ipd) ), (NOT C_ipd) ) OR (( (NOT A_ipd)  AND  B_ipd ) OR ( (NOT A_ipd)  AND  (NOT C_ipd) )));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO12_VITAL of AO12 is 
    for VITAL_ACT
    end for;
 end CFG_AO12_VITAL;



 ---- CELL AO13 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO13 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO13 :  entity is TRUE;
 end AO13;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO13 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) OR ( A_ipd  AND  (NOT C_ipd) )) OR ( B_ipd  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO13_VITAL of AO13 is 
    for VITAL_ACT
    end for;
 end CFG_AO13_VITAL;



 ---- CELL AO14 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO14 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO14 :  entity is TRUE;
 end AO14;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO14 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( (NOT A_ipd)  AND  (NOT B_ipd) ), B_ipd , C_ipd ) OR (( A_ipd  AND  B_ipd ) OR ( A_ipd  AND  (NOT C_ipd) )));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO14_VITAL of AO14 is 
    for VITAL_ACT
    end for;
 end CFG_AO14_VITAL;



 ---- CELL AO15 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO15 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO15 :  entity is TRUE;
 end AO15;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO15 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( A_ipd  AND  (NOT B_ipd) ),( (NOT A_ipd)  AND  (NOT B_ipd) ), C_ipd ) OR (( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO15_VITAL of AO15 is 
    for VITAL_ACT
    end for;
 end CFG_AO15_VITAL;



 ---- CELL AO16 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO16 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO16 :  entity is TRUE;
 end AO16;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO16 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2(( A_ipd  AND  B_ipd ),( (NOT A_ipd)  AND  (NOT B_ipd) ), (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO16_VITAL of AO16 is 
    for VITAL_ACT
    end for;
 end CFG_AO16_VITAL;



 ---- CELL AO17 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO17 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO17 :  entity is TRUE;
 end AO17;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO17 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( (NOT A_ipd)  AND  (NOT B_ipd) ),( (NOT A_ipd)  AND  B_ipd ), C_ipd ) OR (( A_ipd  AND  B_ipd ) AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO17_VITAL of AO17 is 
    for VITAL_ACT
    end for;
 end CFG_AO17_VITAL;



 ---- CELL AO18 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO18 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO18 :  entity is TRUE;
 end AO18;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO18 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) OR ( (NOT A_ipd)  AND  (NOT C_ipd) )) OR ( B_ipd  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO18_VITAL of AO18 is 
    for VITAL_ACT
    end for;
 end CFG_AO18_VITAL;



 ---- CELL AO1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1A :  entity is TRUE;
 end AO1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1A_VITAL of AO1A is 
    for VITAL_ACT
    end for;
 end CFG_AO1A_VITAL;



 ---- CELL AO1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1B :  entity is TRUE;
 end AO1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1B_VITAL of AO1B is 
    for VITAL_ACT
    end for;
 end CFG_AO1B_VITAL;



 ---- CELL AO1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1C :  entity is TRUE;
 end AO1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1C_VITAL of AO1C is 
    for VITAL_ACT
    end for;
 end CFG_AO1C_VITAL;



 ---- CELL AO1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1D :  entity is TRUE;
 end AO1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1D_VITAL of AO1D is 
    for VITAL_ACT
    end for;
 end CFG_AO1D_VITAL;



 ---- CELL AO1E ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1E is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1E :  entity is TRUE;
 end AO1E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO1E is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1E_VITAL of AO1E is 
    for VITAL_ACT
    end for;
 end CFG_AO1E_VITAL;



 ---- CELL AO2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2 :  entity is TRUE;
 end AO2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) OR  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2_VITAL of AO2 is 
    for VITAL_ACT
    end for;
 end CFG_AO2_VITAL;



 ---- CELL AO2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2A :  entity is TRUE;
 end AO2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2A_VITAL of AO2A is 
    for VITAL_ACT
    end for;
 end CFG_AO2A_VITAL;



 ---- CELL AO2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2B :  entity is TRUE;
 end AO2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2B_VITAL of AO2B is 
    for VITAL_ACT
    end for;
 end CFG_AO2B_VITAL;



 ---- CELL AO2C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2C :  entity is TRUE;
 end AO2C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO2C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) OR  (NOT C_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2C_VITAL of AO2C is 
    for VITAL_ACT
    end for;
 end CFG_AO2C_VITAL;



 ---- CELL AO2D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2D :  entity is TRUE;
 end AO2D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO2D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2D_VITAL of AO2D is 
    for VITAL_ACT
    end for;
 end CFG_AO2D_VITAL;



 ---- CELL AO2E ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2E is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2E :  entity is TRUE;
 end AO2E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO2E is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) ) OR  (NOT D_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2E_VITAL of AO2E is 
    for VITAL_ACT
    end for;
 end CFG_AO2E_VITAL;



 ---- CELL AO3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO3 :  entity is TRUE;
 end AO3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO3_VITAL of AO3 is 
    for VITAL_ACT
    end for;
 end CFG_AO3_VITAL;



 ---- CELL AO3A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO3A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO3A :  entity is TRUE;
 end AO3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO3A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) AND  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO3A_VITAL of AO3A is 
    for VITAL_ACT
    end for;
 end CFG_AO3A_VITAL;



 ---- CELL AO3B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO3B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO3B :  entity is TRUE;
 end AO3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO3B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO3B_VITAL of AO3B is 
    for VITAL_ACT
    end for;
 end CFG_AO3B_VITAL;



 ---- CELL AO3C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO3C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO3C :  entity is TRUE;
 end AO3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO3C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO3C_VITAL of AO3C is 
    for VITAL_ACT
    end for;
 end CFG_AO3C_VITAL;



 ---- CELL AO4A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO4A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO4A :  entity is TRUE;
 end AO4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO4A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2(( B_ipd  AND  C_ipd ),( C_ipd  AND  D_ipd ), (NOT A_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO4A_VITAL of AO4A is 
    for VITAL_ACT
    end for;
 end CFG_AO4A_VITAL;



 ---- CELL AO5A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO5A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO5A :  entity is TRUE;
 end AO5A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO5A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2( B_ipd , C_ipd , (NOT A_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO5A_VITAL of AO5A is 
    for VITAL_ACT
    end for;
 end CFG_AO5A_VITAL;



 ---- CELL AO6 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO6 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO6 :  entity is TRUE;
 end AO6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO6 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR ( C_ipd  AND  D_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO6_VITAL of AO6 is 
    for VITAL_ACT
    end for;
 end CFG_AO6_VITAL;



 ---- CELL AO6A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO6A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO6A :  entity is TRUE;
 end AO6A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO6A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR ( C_ipd  AND  (NOT D_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO6A_VITAL of AO6A is 
    for VITAL_ACT
    end for;
 end CFG_AO6A_VITAL;



 ---- CELL AO7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO7 :  entity is TRUE;
 end AO7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (((( A_ipd  AND  B_ipd ) AND  C_ipd ) OR  D_ipd ) OR  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO7_VITAL of AO7 is 
    for VITAL_ACT
    end for;
 end CFG_AO7_VITAL;



 ---- CELL AO8 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO8 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO8 :  entity is TRUE;
 end AO8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO8 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) OR ( (NOT C_ipd)  AND  (NOT D_ipd) )) OR  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO8_VITAL of AO8 is 
    for VITAL_ACT
    end for;
 end CFG_AO8_VITAL;



 ---- CELL AO9 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO9 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO9 :  entity is TRUE;
 end AO9;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AO9 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (((( A_ipd  AND  B_ipd ) OR  C_ipd ) OR  D_ipd ) OR  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO9_VITAL of AO9 is 
    for VITAL_ACT
    end for;
 end CFG_AO9_VITAL;



 ---- CELL AOI1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1 :  entity is TRUE;
 end AOI1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1_VITAL of AOI1 is 
    for VITAL_ACT
    end for;
 end CFG_AOI1_VITAL;



 ---- CELL AOI1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1A :  entity is TRUE;
 end AOI1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1A_VITAL of AOI1A is 
    for VITAL_ACT
    end for;
 end CFG_AOI1A_VITAL;



 ---- CELL AOI1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1B :  entity is TRUE;
 end AOI1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1B_VITAL of AOI1B is 
    for VITAL_ACT
    end for;
 end CFG_AOI1B_VITAL;



 ---- CELL AOI1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1C :  entity is TRUE;
 end AOI1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1C_VITAL of AOI1C is 
    for VITAL_ACT
    end for;
 end CFG_AOI1C_VITAL;



 ---- CELL AOI1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1D :  entity is TRUE;
 end AOI1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1D_VITAL of AOI1D is 
    for VITAL_ACT
    end for;
 end CFG_AOI1D_VITAL;



 ---- CELL AOI2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI2A :  entity is TRUE;
 end AOI2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI2A_VITAL of AOI2A is 
    for VITAL_ACT
    end for;
 end CFG_AOI2A_VITAL;



 ---- CELL AOI2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI2B :  entity is TRUE;
 end AOI2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  AND  B_ipd ) OR  (NOT C_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI2B_VITAL of AOI2B is 
    for VITAL_ACT
    end for;
 end CFG_AOI2B_VITAL;



 ---- CELL AOI3A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI3A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI3A :  entity is TRUE;
 end AOI3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI3A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  OR  B_ipd ) OR  C_ipd ) AND ( A_ipd  OR  D_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI3A_VITAL of AOI3A is 
    for VITAL_ACT
    end for;
 end CFG_AOI3A_VITAL;



 ---- CELL AOI4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI4 :  entity is TRUE;
 end AOI4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) OR ( C_ipd  AND  D_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI4_VITAL of AOI4 is 
    for VITAL_ACT
    end for;
 end CFG_AOI4_VITAL;



 ---- CELL AOI4A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI4A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI4A :  entity is TRUE;
 end AOI4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI4A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) OR ( (NOT C_ipd)  AND  D_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI4A_VITAL of AOI4A is 
    for VITAL_ACT
    end for;
 end CFG_AOI4A_VITAL;



 ---- CELL AOI5 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI5 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI5 :  entity is TRUE;
 end AOI5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AOI5 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT VitalMUX2(( (NOT A_ipd)  AND  B_ipd ),( A_ipd  AND  (NOT B_ipd) ), C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI5_VITAL of AOI5 is 
    for VITAL_ACT
    end for;
 end CFG_AOI5_VITAL;



 ---- CELL AX1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1 :  entity is TRUE;
 end AX1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AX1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1_VITAL of AX1 is 
    for VITAL_ACT
    end for;
 end CFG_AX1_VITAL;



 ---- CELL AX1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1A :  entity is TRUE;
 end AX1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AX1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1A_VITAL of AX1A is 
    for VITAL_ACT
    end for;
 end CFG_AX1A_VITAL;



 ---- CELL AX1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1B :  entity is TRUE;
 end AX1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AX1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1B_VITAL of AX1B is 
    for VITAL_ACT
    end for;
 end CFG_AX1B_VITAL;



 ---- CELL AX1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1C :  entity is TRUE;
 end AX1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AX1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1C_VITAL of AX1C is 
    for VITAL_ACT
    end for;
 end CFG_AX1C_VITAL;



 ---- CELL AX1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1D :  entity is TRUE;
 end AX1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AX1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1D_VITAL of AX1D is 
    for VITAL_ACT
    end for;
 end CFG_AX1D_VITAL;



 ---- CELL AX1E ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1E is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1E :  entity is TRUE;
 end AX1E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AX1E is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1E_VITAL of AX1E is 
    for VITAL_ACT
    end for;
 end CFG_AX1E_VITAL;



 ---- CELL AXO1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO1 :  entity is TRUE;
 end AXO1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXO1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , A_ipd , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO1_VITAL of AXO1 is 
    for VITAL_ACT
    end for;
 end CFG_AXO1_VITAL;



 ---- CELL AXO2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO2 :  entity is TRUE;
 end AXO2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXO2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , (NOT A_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO2_VITAL of AXO2 is 
    for VITAL_ACT
    end for;
 end CFG_AXO2_VITAL;



 ---- CELL AXO3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO3 :  entity is TRUE;
 end AXO3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXO3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( A_ipd , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO3_VITAL of AXO3 is 
    for VITAL_ACT
    end for;
 end CFG_AXO3_VITAL;



 ---- CELL AXO5 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO5 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO5 :  entity is TRUE;
 end AXO5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXO5 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( B_ipd  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO5_VITAL of AXO5 is 
    for VITAL_ACT
    end for;
 end CFG_AXO5_VITAL;



 ---- CELL AXO6 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO6 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO6 :  entity is TRUE;
 end AXO6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXO6 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT B_ipd)  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , A_ipd , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO6_VITAL of AXO6 is 
    for VITAL_ACT
    end for;
 end CFG_AXO6_VITAL;



 ---- CELL AXO7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO7 :  entity is TRUE;
 end AXO7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXO7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO7_VITAL of AXO7 is 
    for VITAL_ACT
    end for;
 end CFG_AXO7_VITAL;



 ---- CELL AXOI1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI1 :  entity is TRUE;
 end AXOI1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXOI1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , A_ipd , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI1_VITAL of AXOI1 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI1_VITAL;



 ---- CELL AXOI2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI2 :  entity is TRUE;
 end AXOI2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXOI2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , (NOT A_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI2_VITAL of AXOI2 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI2_VITAL;



 ---- CELL AXOI3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI3 :  entity is TRUE;
 end AXOI3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXOI3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( A_ipd , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI3_VITAL of AXOI3 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI3_VITAL;



 ---- CELL AXOI4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI4 :  entity is TRUE;
 end AXOI4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXOI4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  C_ipd ) OR  VitalMUX2( A_ipd , (NOT C_ipd) , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI4_VITAL of AXOI4 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI4_VITAL;



 ---- CELL AXOI5 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI5 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI5 :  entity is TRUE;
 end AXOI5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXOI5 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI5_VITAL of AXOI5 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI5_VITAL;



 ---- CELL AXOI7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI7 :  entity is TRUE;
 end AXOI7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of AXOI7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI7_VITAL of AXOI7 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI7_VITAL;



 ---- CELL BIBUF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.000 ns, 0.000 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF :  entity is TRUE;
 end BIBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of BIBUF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_VITAL of BIBUF is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_VITAL;



 ---- CELL BUFA ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BUFA is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BUFA :  entity is TRUE;
 end BUFA;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of BUFA is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BUFA_VITAL of BUFA is 
    for VITAL_ACT
    end for;
 end CFG_BUFA_VITAL;



 ---- CELL BUFD ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BUFD is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BUFD :  entity is TRUE;
 end BUFD;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of BUFD is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BUFD_VITAL of BUFD is 
    for VITAL_ACT
    end for;
 end CFG_BUFD_VITAL;



 ---- CELL BUFF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BUFF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BUFF :  entity is TRUE;
 end BUFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of BUFF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BUFF_VITAL of BUFF is 
    for VITAL_ACT
    end for;
 end CFG_BUFF_VITAL;



 ---- CELL CLKBUF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF :  entity is TRUE;
 end CLKBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CLKBUF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_VITAL of CLKBUF is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_VITAL;



 ---- CELL CLKBUFI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUFI is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUFI :  entity is TRUE;
 end CLKBUFI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CLKBUFI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  (NOT PAD_ipd) ;


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUFI_VITAL of CLKBUFI is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUFI_VITAL;



 ---- CELL CLKINT ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKINT is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKINT :  entity is TRUE;
 end CLKINT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CLKINT is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKINT_VITAL of CLKINT is 
    for VITAL_ACT
    end for;
 end CFG_CLKINT_VITAL;



 ---- CELL CLKINTI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKINTI is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKINTI :  entity is TRUE;
 end CLKINTI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CLKINTI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  (NOT A_ipd) ;


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKINTI_VITAL of CLKINTI is 
    for VITAL_ACT
    end for;
 end CFG_CLKINTI_VITAL;



 ---- CELL CM7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CM7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S0		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CM7 :  entity is TRUE;
 end CM7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CM7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S0_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S0_ipd, S0, tipd_S0);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S0_ipd, D1_ipd, S10_ipd, S11_ipd, D2_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , (NOT S0_ipd) ), VitalMUX2( D2_ipd , D3_ipd , (NOT S0_ipd) ), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S0_ipd'last_event,tpd_S0_Y, true),
	             2 => (D1_ipd'last_event,tpd_D1_Y, true),
	             3 => (S10_ipd'last_event,tpd_S10_Y, true),
	             4 => (S11_ipd'last_event,tpd_S11_Y, true),
	             5 => (D2_ipd'last_event,tpd_D2_Y, true),
	             6 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CM7_VITAL of CM7 is 
    for VITAL_ACT
    end for;
 end CFG_CM7_VITAL;



 ---- CELL CM8 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CM8 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CM8 :  entity is TRUE;
 end CM8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CM8 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, D2_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , NOT (  S00_ipd  AND  S01_ipd )), VitalMUX2( D2_ipd , D3_ipd , NOT (  S00_ipd  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D2_ipd'last_event,tpd_D2_Y, true),
	             7 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CM8_VITAL of CM8 is 
    for VITAL_ACT
    end for;
 end CFG_CM8_VITAL;



 ---- CELL CM8INV ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CM8INV is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CM8INV :  entity is TRUE;
 end CM8INV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CM8INV is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  (NOT A_ipd) ;


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CM8INV_VITAL of CM8INV is 
    for VITAL_ACT
    end for;
 end CFG_CM8INV_VITAL;



 ---- CELL CMA9 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMA9 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMA9 :  entity is TRUE;
 end CMA9;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMA9 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, DB_ipd, S01_ipd, S11_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	CONSTANT CMA9_table : VitalTruthTableType(0 to 10, 0 to 5) :=
	-- Input Pattern                   Response
   -- D0   DB   D3   S01  S11          Y
	(( '-', '0', '-', '0', '-',        '1'), --0
	 ( '-', '1', '-', '-', '1',        '0'),
	 ( '-', '0', '0', '1', '-',        '0'),
	 ( '1', '1', '-', '-', '0',        '1'),
	 ( '1', '-', '1', '-', '0',        '1'),
	 ( '-', '0', '1', '-', '-',        '1'), --5
	 ( '0', '1', '-', '-', '-',        '0'),
	 ( '0', '-', '0', '1', '-',        '0'),
	 ( '1', '-', '-', '0', '0',        '1'),
	 ( '-', '0', '1', '1', '-',        '1'),
	 ( '-', '-', '0', '1', '1',        '0')); --10

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
   Y_zd := VitalTruthTable(
            TruthTable => CMA9_table,
             DataIn => (
              D0_ipd, DB_ipd, D3_ipd, S01_ipd, S11_ipd));



	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (DB_ipd'last_event,tpd_DB_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (S11_ipd'last_event,tpd_S11_Y, true),
	             4 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMA9_VITAL of CMA9 is 
    for VITAL_ACT
    end for;
 end CFG_CMA9_VITAL;



 ---- CELL CMAF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMAF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMAF :  entity is TRUE;
 end CMAF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMAF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, DB_ipd, S11_ipd, D2_ipd, S01_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	CONSTANT CMAF_table : VitalTruthTableType(0 to 25, 0 to 6) :=
	  -- Input Pattern                             Response
	  -- D0   D2   D3   DB   S01  S11       Y
	  (( '0', '0', '0', '-', '-', '-',     '0'), --0
	   ( '1', '1', '1', '-', '-', '-',     '1'),
	   ( '0', '0', '-', '-', '0', '0',     '0'),
	   ( '1', '1', '-', '-', '0', '0',     '1'),
	   ( '0', '0', '-', '1', '-', '-',     '0'),
	   ( '1', '1', '-', '1', '-', '-',     '1'), --5
	   ( '0', '0', '-', '-', '0', '-',     '0'),
	   ( '1', '1', '-', '-', '0', '-',     '1'),
	   ( '-', '0', '0', '-', '1', '1',     '0'),
	   ( '-', '1', '1', '-', '1', '1',     '1'),
	   ( '-', '0', '0', '0', '-', '-',     '0'), --10
	   ( '-', '1', '1', '0', '-', '-',     '1'),
	   ( '-', '0', '0', '-', '-', '1',     '0'),
	   ( '-', '1', '1', '-', '-', '1',     '1'),
	   ( '0', '-', '0', '-', '1', '0',     '0'),
	   ( '1', '-', '1', '-', '1', '0',     '1'), --15
	   ( '-', '0', '-', '0', '0', '-',     '0'),
	   ( '-', '1', '-', '0', '0', '-',     '1'),
	   ( '-', '0', '-', '1', '-', '1',     '0'),
	   ( '-', '1', '-', '1', '-', '1',     '1'),
	   ( '-', '0', '-', '-', '0', '1',     '0'), --20
	   ( '-', '1', '-', '-', '0', '1',     '1'),
	   ( '-', '-', '0', '0', '1', '-',     '0'),
	   ( '-', '-', '1', '0', '1', '-',     '1'),
	   ( '0', '-', '-', '1', '-', '0',     '0'),
  	   ( '1', '-', '-', '1', '-', '0',     '1')); --25

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
      Y_zd := VitalTruthTable(
             TruthTable => CMAF_table,
             DataIn => (
              D0_ipd, D2_ipd, D3_ipd, DB_ipd, S01_ipd, S11_ipd));



	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (DB_ipd'last_event,tpd_DB_Y, true),
	             2 => (S11_ipd'last_event,tpd_S11_Y, true),
	             3 => (D2_ipd'last_event,tpd_D2_Y, true),
	             4 => (S01_ipd'last_event,tpd_S01_Y, true),
	             5 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMAF_VITAL of CMAF is 
    for VITAL_ACT
    end for;
 end CFG_CMAF_VITAL;



 ---- CELL CMB3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMB3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMB3 :  entity is TRUE;
 end CMB3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMB3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, D1_ipd, DB_ipd, S11_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , NOT (  S00_ipd  AND  S01_ipd )), VitalMUX2( (NOT DB_ipd) , (NOT DB_ipd) , NOT (  S00_ipd  AND  S01_ipd )), NOT (  (NOT DB_ipd)  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (DB_ipd'last_event,tpd_DB_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMB3_VITAL of CMB3 is 
    for VITAL_ACT
    end for;
 end CFG_CMB3_VITAL;



 ---- CELL CMB7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMB7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMB7 :  entity is TRUE;
 end CMB7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMB7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, D1_ipd, DB_ipd, S11_ipd, D2_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

  CONSTANT CMB7_table : VitalTruthTableType(0 to 24, 0 to 7) :=
  -- Input Pattern                             Response
  -- D0   D1   D2   DB   S00  S01  S11          Y
  (( '0', '0', '0', '1', '-', '-', '-',        '0'), --0
   ( '-', '-', '1', '0', '-', '-', '-',        '1'),
   ( '-', '0', '-', '1', '1', '1', '0',        '0'),
   ( '-', '1', '-', '-', '1', '1', '0',        '1'),
   ( '0', '-', '-', '1', '0', '-', '0',        '0'),
   ( '0', '-', '-', '1', '-', '0', '0',        '0'), --5
   ( '1', '-', '-', '1', '0', '-', '0',        '1'),
   ( '1', '-', '-', '1', '-', '0', '0',        '1'),
   ( '-', '-', '-', '1', '1', '1', '1',        '0'),
   ( '-', '-', '-', '0', '1', '1', '-',        '1'),
   ( '-', '-', '0', '0', '0', '-', '-',        '0'), --10
   ( '-', '-', '0', '0', '-', '0', '-',        '0'),
   ( '-', '-', '0', '-', '0', '-', '1',        '0'),
   ( '-', '-', '0', '-', '-', '0', '1',        '0'),
   ( '0', '-', '0', '-', '0', '-', '-',        '0'),
   ( '0', '-', '0', '-', '-', '0', '-',        '0'), --15
   ( '1', '-', '1', '-', '0', '-', '-',        '1'),
   ( '1', '-', '1', '-', '-', '0', '-',        '1'),
   ( '-', '-', '1', '-', '0', '-', '1',        '1'),
   ( '-', '-', '1', '-', '-', '0', '1',        '1'),
   ( '-', '0', '-', '1', '1', '1', '-',        '0'), --20
   ( '0', '0', '-', '1', '-', '-', '0',        '0'),
   ( '1', '1', '-', '1', '-', '-', '0',        '1'),
   ( '-', '-', '0', '1', '-', '-', '1',        '0'),
   ( '1', '1', '1', '-', '-', '-', '0',        '1'));

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
    Y_zd := VitalTruthTable (
             TruthTable => CMB7_table,
             DataIn => (
              D0_ipd, D1_ipd, D2_ipd, DB_ipd, S00_ipd, S01_ipd, S11_ipd));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (DB_ipd'last_event,tpd_DB_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D2_ipd'last_event,tpd_D2_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMB7_VITAL of CMB7 is 
    for VITAL_ACT
    end for;
 end CFG_CMB7_VITAL;



 ---- CELL CMBB ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMBB is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMBB :  entity is TRUE;
 end CMBB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMBB is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, D1_ipd, DB_ipd, S11_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

 CONSTANT CMBB_table : VitalTruthTableType(0 to 23, 0 to 7) :=
  -- Input Pattern                             Response
  -- D0   D1   DB   D3   S00  S01  S11          Y
  (( '0', '0', '1', '0', '-', '-', '-',        '0'), --0
   ( '-', '-', '0', '1', '-', '-', '-',        '1'),
   ( '-', '-', '0', '-', '-', '0', '-',        '1'),
   ( '-', '-', '1', '-', '-', '0', '1',        '0'),
   ( '-', '-', '0', '-', '0', '-', '-',        '1'),
   ( '-', '-', '1', '-', '0', '-', '1',        '0'), --5
   ( '0', '-', '1', '-', '-', '0', '0',        '0'),
   ( '1', '-', '-', '-', '-', '0', '0',        '1'),
   ( '0', '-', '1', '-', '0', '-', '0',        '0'),
   ( '1', '-', '-', '-', '0', '-', '0',        '1'),
   ( '-', '0', '1', '-', '1', '1', '0',        '0'), --10
   ( '-', '1', '1', '-', '1', '1', '0',        '1'),
   ( '-', '-', '-', '0', '1', '1', '1',        '0'),
   ( '-', '-', '-', '1', '1', '1', '1',        '1'),
   ( '-', '-', '0', '0', '1', '1', '-',        '0'),
   ( '-', '-', '0', '1', '1', '1', '-',        '1'), --15
   ( '-', '-', '1', '0', '-', '-', '1',        '0'),
   ( '-', '0', '-', '0', '1', '1', '-',        '0'),
   ( '-', '1', '-', '1', '1', '1', '-',        '1'),
   ( '0', '-', '1', '-', '0', '-', '-',        '0'),
   ( '0', '0', '1', '-', '-', '-', '0',        '0'), --20
   ( '1', '1', '1', '-', '-', '-', '0',        '1'),
   ( '0', '-', '1', '-', '-', '0', '-',        '0'),
   ( '1', '1', '-', '1', '-', '-', '0',        '1'));

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
   Y_zd := VitalTruthTable(
           TruthTable => CMBB_table,
             DataIn => (
              D0_ipd, D1_ipd, DB_ipd, D3_ipd, S00_ipd, S01_ipd, S11_ipd));



	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (DB_ipd'last_event,tpd_DB_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMBB_VITAL of CMBB is 
    for VITAL_ACT
    end for;
 end CFG_CMBB_VITAL;



 ---- CELL CMBF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMBF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMBF :  entity is TRUE;
 end CMBF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMBF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, D1_ipd, DB_ipd, S11_ipd, D2_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , NOT (  S00_ipd  AND  S01_ipd )), VitalMUX2( D2_ipd , D3_ipd , NOT (  S00_ipd  AND  S01_ipd )), NOT (  (NOT DB_ipd)  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (DB_ipd'last_event,tpd_DB_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D2_ipd'last_event,tpd_D2_Y, true),
	             7 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMBF_VITAL of CMBF is 
    for VITAL_ACT
    end for;
 end CFG_CMBF_VITAL;



 ---- CELL CMEA ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMEA is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMEA :  entity is TRUE;
 end CMEA;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMEA is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (DB_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

   CONSTANT CMEA_table : VitalTruthTableType(0 to 14, 0 to 6) :=
         -- Input Pattern                        Response
         -- DB   D1   D3   S01  S10  S11          Y
         (( '1', '-', '-', '-', '-', '-',        '0'), --0
          ( '0', '1', '1', '-', '-', '-',        '1'),
          ( '0', '0', '-', '1', '0', '0',        '0'),
          ( '0', '1', '-', '-', '0', '0',        '1'),
          ( '-', '0', '-', '1', '0', '0',        '0'),
          ( '0', '-', '0', '1', '1', '-',        '0'),
          ( '0', '-', '0', '1', '-', '1',        '0'), --5
          ( '0', '-', '-', '0', '-', '-',        '1'),
          ( '-', '0', '0', '1', '-', '-',        '0'),
          ( '-', '1', '0', '1', '1', '-',        '0'),
          ( '-', '1', '0', '1', '-', '1',        '0'),
          ( '-', '-', '0', '1', '1', '-',        '0'),
          ( '-', '-', '0', '1', '-', '1',        '0'),
          ( '0', '-', '1', '-', '1', '-',        '1'),
          ( '0', '-', '1', '-', '-', '1',        '1'));

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
      Y_zd := VitalTruthTable(
             TruthTable => CMEA_table,
             DataIn => (
              DB_ipd, D1_ipd, D3_ipd, S01_ipd, S10_ipd, S11_ipd));



	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (DB_ipd'last_event,tpd_DB_Y, true),
	             1 => (S01_ipd'last_event,tpd_S01_Y, true),
	             2 => (D1_ipd'last_event,tpd_D1_Y, true),
	             3 => (S10_ipd'last_event,tpd_S10_Y, true),
	             4 => (S11_ipd'last_event,tpd_S11_Y, true),
	             5 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMEA_VITAL of CMEA is 
    for VITAL_ACT
    end for;
 end CFG_CMEA_VITAL;



 ---- CELL CMEB ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMEB is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMEB :  entity is TRUE;
 end CMEB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMEB is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, DB_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	CONSTANT CMEB_table : VitalTruthTableType(0 to 24, 0 to 7) :=
	  -- Input Pattern                             Response
	  -- D0   D1   DB   D3   S01  S10  S11          Y
	  (( '0', '0', '1', '0', '-', '-', '-',        '0'), --0
	   ( '1', '1', '0', '1', '-', '-', '-',        '1'),
	   ( '0', '-', '-', '-', '0', '0', '0',        '0'),
	   ( '1', '-', '-', '-', '0', '0', '0',        '1'),
	   ( '0', '-', '1', '-', '-', '0', '0',        '0'),
	   ( '1', '-', '1', '-', '-', '0', '0',        '1'), --5
	   ( '-', '-', '0', '1', '1', '1', '-',        '1'),
	   ( '-', '-', '0', '1', '1', '-', '1',        '1'),
	   ( '-', '0', '0', '-', '1', '0', '0',        '0'),
	   ( '-', '1', '0', '-', '1', '0', '0',        '1'),
 	   ( '-', '-', '-', '0', '1', '1', '-',        '0'), --10
	   ( '-', '-', '-', '0', '1', '-', '1',        '0'),
	   ( '-', '-', '1', '-', '-', '1', '-',        '0'),
	   ( '-', '-', '1', '-', '-', '-', '1',        '0'),
	   ( '-', '-', '0', '-', '0', '1', '-',        '1'),
	   ( '-', '0', '0', '0', '1', '-', '-',        '0'), --15
	   ( '-', '1', '0', '1', '1', '-', '-',        '1'),
	   ( '0', '0', '-', '-', '-', '0', '0',        '0'),
	   ( '1', '1', '-', '-', '-', '0', '0',        '1'),
	   ( '0', '-', '1', '-', '-', '-', '-',        '0'),
	   ( '1', '-', '0', '-', '0', '-', '-',        '1'), --20
	   ( '-', '-', '0', '1', '-', '1', '-',        '1'),
	   ( '-', '-', '0', '1', '-', '-', '1',        '1'),
	   ( '-', '-', '0', '-', '0', '-', '1',        '1'),
	   ( '0', '0', '-', '0', '1', '-', '-',        '0'));

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
    Y_zd := VitalTruthTable(
     TruthTable => CMEB_table,
             DataIn => (
              D0_ipd, D1_ipd, DB_ipd, D3_ipd, S01_ipd, S10_ipd, S11_ipd));



	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (DB_ipd'last_event,tpd_DB_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMEB_VITAL of CMEB is 
    for VITAL_ACT
    end for;
 end CFG_CMEB_VITAL;



 ---- CELL CMEE ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMEE is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMEE :  entity is TRUE;
 end CMEE;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMEE is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (DB_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, D2_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	CONSTANT CMEE_table : VitalTruthTableType(0 to 27, 0 to 7) :=
	  -- Input Pattern                             Response
	  -- DB   D1   D2   D3   S01  S10  S11          Y
	  (( '1', '0', '0', '0', '-', '-', '-',        '0'), --0
	   ( '0', '1', '1', '1', '-', '-', '-',        '1'),
	   ( '-', '0', '-', '-', '1', '0', '0',        '0'),
	   ( '0', '1', '-', '-', '1', '0', '0',        '1'),
	   ( '0', '-', '-', '0', '1', '1', '-',        '0'),
	   ( '0', '-', '-', '1', '1', '1', '-',        '1'), --5
	   ( '0', '-', '-', '0', '1', '-', '1',        '0'),
	   ( '0', '-', '-', '1', '1', '-', '1',        '1'),
	   ( '1', '-', '-', '-', '-', '0', '0',        '0'),
	   ( '0', '-', '-', '-', '0', '0', '0',        '1'),
	   ( '-', '-', '0', '-', '0', '-', '1',        '0'), --10
	   ( '-', '-', '1', '-', '0', '-', '1',        '1'),
	   ( '-', '-', '0', '-', '0', '1', '-',        '0'),
	   ( '-', '-', '1', '-', '0', '1', '-',        '1'),
	   ( '1', '-', '0', '-', '-', '-', '1',        '0'),
	   ( '1', '-', '1', '-', '-', '-', '1',        '1'), --15
	   ( '1', '-', '0', '-', '-', '1', '-',        '0'),
	   ( '1', '-', '1', '-', '-', '1', '-',        '1'),
	   ( '1', '-', '0', '-', '-', '-', '-',        '0'),
	   ( '0', '-', '1', '-', '0', '-', '-',        '1'),
	   ( '-', '-', '0', '0', '-', '1', '-',        '0'), --20
	   ( '-', '-', '1', '1', '-', '1', '-',        '1'),
	   ( '-', '-', '0', '0', '-', '-', '1',        '0'),
	   ( '0', '0', '-', '0', '1', '-', '-',        '0'),
	   ( '0', '1', '-', '1', '1', '-', '-',        '1'),
	   ( '-', '-', '1', '1', '-', '-', '1',        '1'), --25
	   ( '0', '1', '-', '-', '-', '0', '0',        '1'),
	   ( '-', '0', '0', '0', '1', '-', '-',        '0'));

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
          Y_zd := VitalTruthTable(
             TruthTable => CMEE_table,
             DataIn => (
              DB_ipd, D1_ipd, D2_ipd, D3_ipd, S01_ipd, S10_ipd, S11_ipd));



	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (DB_ipd'last_event,tpd_DB_Y, true),
	             1 => (S01_ipd'last_event,tpd_S01_Y, true),
	             2 => (D1_ipd'last_event,tpd_D1_Y, true),
	             3 => (S10_ipd'last_event,tpd_S10_Y, true),
	             4 => (S11_ipd'last_event,tpd_S11_Y, true),
	             5 => (D2_ipd'last_event,tpd_D2_Y, true),
	             6 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMEE_VITAL of CMEE is 
    for VITAL_ACT
    end for;
 end CFG_CMEE_VITAL;



 ---- CELL CMEF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMEF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMEF :  entity is TRUE;
 end CMEF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMEF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, DB_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, D2_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , NOT (  (NOT DB_ipd)  AND  S01_ipd )), VitalMUX2( D2_ipd , D3_ipd , NOT (  (NOT DB_ipd)  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (DB_ipd'last_event,tpd_DB_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D2_ipd'last_event,tpd_D2_Y, true),
	             7 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMEF_VITAL of CMEF is 
    for VITAL_ACT
    end for;
 end CFG_CMEF_VITAL;



 ---- CELL CMF1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMF1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMF1 :  entity is TRUE;
 end CMF1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMF1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, DB_ipd, S10_ipd, S11_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , (NOT DB_ipd) , NOT (  S00_ipd  AND  S01_ipd )), (NOT DB_ipd) , NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (DB_ipd'last_event,tpd_DB_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMF1_VITAL of CMF1 is 
    for VITAL_ACT
    end for;
 end CFG_CMF1_VITAL;



 ---- CELL CMF2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMF2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMF2 :  entity is TRUE;
 end CMF2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMF2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (DB_ipd, S00_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( (NOT DB_ipd) , D1_ipd , NOT (  S00_ipd  AND  S01_ipd )), (NOT DB_ipd) , NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (DB_ipd'last_event,tpd_DB_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMF2_VITAL of CMF2 is 
    for VITAL_ACT
    end for;
 end CFG_CMF2_VITAL;



 ---- CELL CMF3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMF3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMF3 :  entity is TRUE;
 end CMF3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMF3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, DB_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , NOT (  S00_ipd  AND  S01_ipd )), (NOT DB_ipd) , NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (DB_ipd'last_event,tpd_DB_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMF3_VITAL of CMF3 is 
    for VITAL_ACT
    end for;
 end CFG_CMF3_VITAL;



 ---- CELL CMF4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMF4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMF4 :  entity is TRUE;
 end CMF4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMF4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (DB_ipd, S10_ipd, S11_ipd, D2_ipd, S00_ipd, S01_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( (NOT DB_ipd) , VitalMUX2( D2_ipd , (NOT DB_ipd) , NOT (  S00_ipd  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (DB_ipd'last_event,tpd_DB_Y, true),
	             1 => (S10_ipd'last_event,tpd_S10_Y, true),
	             2 => (S11_ipd'last_event,tpd_S11_Y, true),
	             3 => (D2_ipd'last_event,tpd_D2_Y, true),
	             4 => (S00_ipd'last_event,tpd_S00_Y, true),
	             5 => (S01_ipd'last_event,tpd_S01_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMF4_VITAL of CMF4 is 
    for VITAL_ACT
    end for;
 end CFG_CMF4_VITAL;



 ---- CELL CMF5 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMF5 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMF5 :  entity is TRUE;
 end CMF5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMF5 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S10_ipd, S11_ipd, D2_ipd, S00_ipd, S01_ipd, DB_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D2_ipd , NOT (  S10_ipd  OR  S11_ipd )), (NOT DB_ipd) , NOT (  S00_ipd  AND  S01_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S10_ipd'last_event,tpd_S10_Y, true),
	             2 => (S11_ipd'last_event,tpd_S11_Y, true),
	             3 => (D2_ipd'last_event,tpd_D2_Y, true),
	             4 => (S00_ipd'last_event,tpd_S00_Y, true),
	             5 => (S01_ipd'last_event,tpd_S01_Y, true),
	             6 => (DB_ipd'last_event,tpd_DB_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMF5_VITAL of CMF5 is 
    for VITAL_ACT
    end for;
 end CFG_CMF5_VITAL;



 ---- CELL CMF6 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMF6 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMF6 :  entity is TRUE;
 end CMF6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMF6 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (DB_ipd, S00_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, D2_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( (NOT DB_ipd) , D1_ipd , NOT (  S00_ipd  AND  S01_ipd )), VitalMUX2( D2_ipd , (NOT DB_ipd) , NOT (  S00_ipd  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (DB_ipd'last_event,tpd_DB_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D2_ipd'last_event,tpd_D2_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMF6_VITAL of CMF6 is 
    for VITAL_ACT
    end for;
 end CFG_CMF6_VITAL;



 ---- CELL CMF7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMF7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMF7 :  entity is TRUE;
 end CMF7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMF7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, D2_ipd, DB_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , NOT (  S00_ipd  AND  S01_ipd )), VitalMUX2( D2_ipd , (NOT DB_ipd) , NOT (  S00_ipd  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D2_ipd'last_event,tpd_D2_Y, true),
	             7 => (DB_ipd'last_event,tpd_DB_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMF7_VITAL of CMF7 is 
    for VITAL_ACT
    end for;
 end CFG_CMF7_VITAL;



 ---- CELL CMF8 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMF8 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMF8 :  entity is TRUE;
 end CMF8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMF8 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (DB_ipd, S10_ipd, S11_ipd, S00_ipd, S01_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( (NOT DB_ipd) , VitalMUX2( (NOT DB_ipd) , D3_ipd , NOT (  S00_ipd  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (DB_ipd'last_event,tpd_DB_Y, true),
	             1 => (S10_ipd'last_event,tpd_S10_Y, true),
	             2 => (S11_ipd'last_event,tpd_S11_Y, true),
	             3 => (S00_ipd'last_event,tpd_S00_Y, true),
	             4 => (S01_ipd'last_event,tpd_S01_Y, true),
	             5 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMF8_VITAL of CMF8 is 
    for VITAL_ACT
    end for;
 end CFG_CMF8_VITAL;



 ---- CELL CMF9 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMF9 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMF9 :  entity is TRUE;
 end CMF9;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMF9 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, DB_ipd, S10_ipd, S11_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , (NOT DB_ipd) , NOT (  S00_ipd  AND  S01_ipd )), VitalMUX2( (NOT DB_ipd) , D3_ipd , NOT (  S00_ipd  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (DB_ipd'last_event,tpd_DB_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMF9_VITAL of CMF9 is 
    for VITAL_ACT
    end for;
 end CFG_CMF9_VITAL;



 ---- CELL CMFA ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMFA is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMFA :  entity is TRUE;
 end CMFA;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMFA is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (DB_ipd, S00_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( (NOT DB_ipd) , VitalMUX2( D1_ipd , D3_ipd , NOT (  S10_ipd  OR  S11_ipd )), NOT (  S00_ipd  AND  S01_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (DB_ipd'last_event,tpd_DB_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMFA_VITAL of CMFA is 
    for VITAL_ACT
    end for;
 end CFG_CMFA_VITAL;



 ---- CELL CMFB ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMFB is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMFB :  entity is TRUE;
 end CMFB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMFB is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, DB_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , NOT (  S00_ipd  AND  S01_ipd )), VitalMUX2( (NOT DB_ipd) , D3_ipd , NOT (  S00_ipd  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (DB_ipd'last_event,tpd_DB_Y, true),
	             7 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMFB_VITAL of CMFB is 
    for VITAL_ACT
    end for;
 end CFG_CMFB_VITAL;



 ---- CELL CMFC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMFC is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMFC :  entity is TRUE;
 end CMFC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMFC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (DB_ipd, S10_ipd, S11_ipd, D2_ipd, S00_ipd, S01_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( (NOT DB_ipd) , VitalMUX2( D2_ipd , D3_ipd , NOT (  S00_ipd  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (DB_ipd'last_event,tpd_DB_Y, true),
	             1 => (S10_ipd'last_event,tpd_S10_Y, true),
	             2 => (S11_ipd'last_event,tpd_S11_Y, true),
	             3 => (D2_ipd'last_event,tpd_D2_Y, true),
	             4 => (S00_ipd'last_event,tpd_S00_Y, true),
	             5 => (S01_ipd'last_event,tpd_S01_Y, true),
	             6 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMFC_VITAL of CMFC is 
    for VITAL_ACT
    end for;
 end CFG_CMFC_VITAL;



 ---- CELL CMFD ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMFD is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMFD :  entity is TRUE;
 end CMFD;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMFD is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S00_ipd, S01_ipd, DB_ipd, S10_ipd, S11_ipd, D2_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , (NOT DB_ipd) , NOT (  S00_ipd  AND  S01_ipd )), VitalMUX2( D2_ipd , D3_ipd , NOT (  S00_ipd  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (DB_ipd'last_event,tpd_DB_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D2_ipd'last_event,tpd_D2_Y, true),
	             7 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMFD_VITAL of CMFD is 
    for VITAL_ACT
    end for;
 end CFG_CMFD_VITAL;



 ---- CELL CMFE ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CMFE is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CMFE :  entity is TRUE;
 end CMFE;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CMFE is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL DB_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (DB_ipd, DB, tipd_DB);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ipd, S01, tipd_S01);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (DB_ipd, S00_ipd, S01_ipd, D1_ipd, S10_ipd, S11_ipd, D2_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( (NOT DB_ipd) , D1_ipd , NOT (  S00_ipd  AND  S01_ipd )), VitalMUX2( D2_ipd , D3_ipd , NOT (  S00_ipd  AND  S01_ipd )), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (DB_ipd'last_event,tpd_DB_Y, true),
	             1 => (S00_ipd'last_event,tpd_S00_Y, true),
	             2 => (S01_ipd'last_event,tpd_S01_Y, true),
	             3 => (D1_ipd'last_event,tpd_D1_Y, true),
	             4 => (S10_ipd'last_event,tpd_S10_Y, true),
	             5 => (S11_ipd'last_event,tpd_S11_Y, true),
	             6 => (D2_ipd'last_event,tpd_D2_Y, true),
	             7 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CMFE_VITAL of CMFE is 
    for VITAL_ACT
    end for;
 end CFG_CMFE_VITAL;



 ---- CELL CS1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CS1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CS1 :  entity is TRUE;
 end CS1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CS1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL S_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (S_ipd, S, tipd_S);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, S_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( C_ipd , D_ipd , NOT (  A_ipd  OR ( S_ipd  AND  B_ipd )));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (S_ipd'last_event,tpd_S_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true),
	             3 => (C_ipd'last_event,tpd_C_Y, true),
	             4 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CS1_VITAL of CS1 is 
    for VITAL_ACT
    end for;
 end CFG_CS1_VITAL;



 ---- CELL CS2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CS2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CS2 :  entity is TRUE;
 end CS2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CS2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL S_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (S_ipd, S, tipd_S);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, S_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( C_ipd , D_ipd , NOT ( ( A_ipd  OR  S_ipd ) AND  B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (S_ipd'last_event,tpd_S_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true),
	             3 => (C_ipd'last_event,tpd_C_Y, true),
	             4 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CS2_VITAL of CS2 is 
    for VITAL_ACT
    end for;
 end CFG_CS2_VITAL;



 ---- CELL CY2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CY2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B0		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A1		: in    STD_ULOGIC;
		B1		: in    STD_ULOGIC;
		A0		: in    STD_ULOGIC;
		B0		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CY2A :  entity is TRUE;
 end CY2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CY2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A1_ipd  : STD_ULOGIC := 'X';
	SIGNAL B1_ipd  : STD_ULOGIC := 'X';
	SIGNAL A0_ipd  : STD_ULOGIC := 'X';
	SIGNAL B0_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A1_ipd, A1, tipd_A1);
	VitalWireDelay (B1_ipd, B1, tipd_B1);
	VitalWireDelay (A0_ipd, A0, tipd_A0);
	VitalWireDelay (B0_ipd, B0, tipd_B0);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A1_ipd, B1_ipd, A0_ipd, B0_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A1_ipd  AND  B1_ipd ) OR (( A0_ipd  AND  B0_ipd ) AND  A1_ipd )) OR (( A0_ipd  AND  B0_ipd ) AND  B1_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A1_ipd'last_event,tpd_A1_Y, true),
	             1 => (B1_ipd'last_event,tpd_B1_Y, true),
	             2 => (A0_ipd'last_event,tpd_A0_Y, true),
	             3 => (B0_ipd'last_event,tpd_B0_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CY2A_VITAL of CY2A is 
    for VITAL_ACT
    end for;
 end CFG_CY2A_VITAL;



 ---- CELL CY2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CY2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B0		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A1		: in    STD_ULOGIC;
		B1		: in    STD_ULOGIC;
		A0		: in    STD_ULOGIC;
		B0		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CY2B :  entity is TRUE;
 end CY2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of CY2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A1_ipd  : STD_ULOGIC := 'X';
	SIGNAL B1_ipd  : STD_ULOGIC := 'X';
	SIGNAL A0_ipd  : STD_ULOGIC := 'X';
	SIGNAL B0_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A1_ipd, A1, tipd_A1);
	VitalWireDelay (B1_ipd, B1, tipd_B1);
	VitalWireDelay (A0_ipd, A0, tipd_A0);
	VitalWireDelay (B0_ipd, B0, tipd_B0);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A1_ipd, B1_ipd, A0_ipd, B0_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A1_ipd  AND  B1_ipd ) OR (( A0_ipd  OR  B0_ipd ) AND  A1_ipd )) OR (( A0_ipd  OR  B0_ipd ) AND  B1_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A1_ipd'last_event,tpd_A1_Y, true),
	             1 => (B1_ipd'last_event,tpd_B1_Y, true),
	             2 => (A0_ipd'last_event,tpd_A0_Y, true),
	             3 => (B0_ipd'last_event,tpd_B0_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CY2B_VITAL of CY2B is 
    for VITAL_ACT
    end for;
 end CFG_CY2B_VITAL;



 ---- CELL DF1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DF1 is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DF1 :  entity is TRUE;
 end DF1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DF1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TRUE, 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DF1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>TRUE,
	 HeaderMsg		=> InstancePath & "DF1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, Q_zd, D_delayed, '0', '1', CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DF1_VITAL of DF1 is
   for VITAL_ACT
   end for;
end CFG_DF1_VITAL;



 ---- CELL DF1_CC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DF1_CC is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DF1_CC :  entity is TRUE;
 end DF1_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DF1_CC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TRUE, 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DF1_CC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>TRUE,
	 HeaderMsg		=> InstancePath & "DF1_CC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, Q_zd, D_delayed, '0', '1', CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DF1_CC_VITAL of DF1_CC is
   for VITAL_ACT
   end for;
end CFG_DF1_CC_VITAL;



 ---- CELL DF1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DF1B is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DF1B :  entity is TRUE;
 end DF1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DF1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TRUE, 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DF1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>TRUE,
	 HeaderMsg		=> InstancePath & "DF1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_ipd, Q_zd, D_delayed, '0', '1', CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DF1B_VITAL of DF1B is
   for VITAL_ACT
   end for;
end CFG_DF1B_VITAL;



 ---- CELL DFC1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFC1B is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFC1B :  entity is TRUE;
 end DFC1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFC1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFC1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_posedge,
	 Removal               => thold_CLR_CLK_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>    TRUE,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFC1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFC1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "DFC1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Pviol_CLR or 
	 Pviol_CLK;


  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_delayed, Q_zd, D_delayed, '0', '1', CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	            1=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFC1B_VITAL of DFC1B is
   for VITAL_ACT
   end for;
end CFG_DFC1B_VITAL;



 ---- CELL DFC1B_CC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFC1B_CC is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFC1B_CC :  entity is TRUE;
 end DFC1B_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFC1B_CC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFC1B_CC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_posedge,
	 Removal               => thold_CLR_CLK_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>    TRUE,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFC1B_CC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFC1B_CC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "DFC1B_CC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Pviol_CLR or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_delayed, Q_zd, D_delayed, '0', '1', CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	            1=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFC1B_CC_VITAL of DFC1B_CC is
   for VITAL_ACT
   end for;
end CFG_DFC1B_CC_VITAL;



 ---- CELL DFC1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFC1D is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFC1D :  entity is TRUE;
 end DFC1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFC1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFC1D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_negedge,
	 TimingData             => Tmkr_CLR_CLK_negedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_negedge,
	 Removal               => thold_CLR_CLK_posedge_negedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>    TRUE,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFC1D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFC1D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "DFC1D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Pviol_CLR or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_ipd, Q_zd, D_delayed, '0', '1', CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	            1=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFC1D_VITAL of DFC1D is
   for VITAL_ACT
   end for;
end CFG_DFC1D_VITAL;



 ---- CELL DFE1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFE1B is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFE1B :  entity is TRUE;
 end DFE1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFE1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFE1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_posedge,
	 TimingData		=> Tmkr_E_CLK_posedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_posedge,
	 SetupLow		=> tsetup_E_CLK_negedge_posedge,
	 HoldHigh		=> thold_E_CLK_posedge_posedge,
	 HoldLow		=> thold_E_CLK_negedge_posedge,
	 CheckEnabled		=>  TRUE,	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFE1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>TRUE,
	 HeaderMsg		=> InstancePath & "DFE1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, Q_zd, D_delayed, E_delayed, '1', CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFE1B_VITAL of DFE1B is
   for VITAL_ACT
   end for;
end CFG_DFE1B_VITAL;



 ---- CELL DFE1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFE1C is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFE1C :  entity is TRUE;
 end DFE1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFE1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFE1C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_negedge,
	 TimingData		=> Tmkr_E_CLK_negedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_negedge,
	 SetupLow		=> tsetup_E_CLK_negedge_negedge,
	 HoldHigh		=> thold_E_CLK_posedge_negedge,
	 HoldLow		=> thold_E_CLK_negedge_negedge,
	 CheckEnabled		=>  TRUE,	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFE1C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>TRUE,
	 HeaderMsg		=> InstancePath & "DFE1C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_ipd, Q_zd, D_delayed, E_delayed, '1', CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFE1C_VITAL of DFE1C is
   for VITAL_ACT
   end for;
end CFG_DFE1C_VITAL;



 ---- CELL DFE3C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFE3C is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFE3C :  entity is TRUE;
 end DFE3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFE3C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLR_ipd,E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_posedge,
	 TimingData		=> Tmkr_E_CLK_posedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_posedge,
	 SetupLow		=> tsetup_E_CLK_negedge_posedge,
	 HoldHigh		=> thold_E_CLK_posedge_posedge,
	 HoldLow		=> thold_E_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd)) ) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_posedge,
	 Removal               => thold_CLR_CLK_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01((NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "DFE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Pviol_CLR or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_delayed, Q_zd, D_delayed, E_delayed, '1', CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	            1=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFE3C_VITAL of DFE3C is
   for VITAL_ACT
   end for;
end CFG_DFE3C_VITAL;



 ---- CELL DFE3D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFE3D is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFE3D :  entity is TRUE;
 end DFE3D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFE3D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLR_ipd,E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFE3D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_negedge,
	 TimingData		=> Tmkr_E_CLK_negedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_negedge,
	 SetupLow		=> tsetup_E_CLK_negedge_negedge,
	 HoldHigh		=> thold_E_CLK_posedge_negedge,
	 HoldLow		=> thold_E_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd)) ) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFE3D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_negedge,
	 TimingData             => Tmkr_CLR_CLK_negedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_negedge,
	 Removal               => thold_CLR_CLK_posedge_negedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01((NOT E_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFE3D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFE3D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "DFE3D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Pviol_CLR or 
	 Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_ipd, Q_zd, D_delayed, E_delayed, '1', CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	            1=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFE3D_VITAL of DFE3D is
   for VITAL_ACT
   end for;
end CFG_DFE3D_VITAL;



 ---- CELL DFE4F ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFE4F is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFE4F :  entity is TRUE;
 end DFE4F;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFE4F is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFE4F",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_posedge,
	 TimingData		=> Tmkr_E_CLK_posedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_posedge,
	 SetupLow		=> tsetup_E_CLK_negedge_posedge,
	 HoldHigh		=> thold_E_CLK_posedge_posedge,
	 HoldLow		=> thold_E_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd)) ) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFE4F",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_posedge,
	 TimingData		=> Tmkr_PRE_CLK_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_posedge,
	 Removal		=> thold_PRE_CLK_posedge_posedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TO_X01((NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFE4F",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFE4F",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 			         TRUE,
	 HeaderMsg		=> InstancePath & "DFE4F",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_PRE_CLK_posedge or 
	 Pviol_PRE or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, Q_zd, D_delayed, E_delayed, PRE_ipd, CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFE4F_VITAL of DFE4F is
   for VITAL_ACT
   end for;
end CFG_DFE4F_VITAL;



 ---- CELL DFE4G ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFE4G is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFE4G :  entity is TRUE;
 end DFE4G;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFE4G is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFE4G",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_negedge,
	 TimingData		=> Tmkr_E_CLK_negedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_negedge,
	 SetupLow		=> tsetup_E_CLK_negedge_negedge,
	 HoldHigh		=> thold_E_CLK_posedge_negedge,
	 HoldLow		=> thold_E_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd)) ) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFE4G",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_negedge,
	 TimingData		=> Tmkr_PRE_CLK_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_negedge,
	 Removal		=> thold_PRE_CLK_posedge_negedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TO_X01((NOT E_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFE4G",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFE4G",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 			         TRUE,
	 HeaderMsg		=> InstancePath & "DFE4G",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Tviol_PRE_CLK_negedge or 
	 Pviol_PRE or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_ipd, Q_zd, D_delayed, E_delayed, PRE_ipd, CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFE4G_VITAL of DFE4G is
   for VITAL_ACT
   end for;
end CFG_DFE4G_VITAL;



 ---- CELL DFEG ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFEG is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFEG :  entity is TRUE;
 end DFEG;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFEG is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,CLR_ipd,E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFEG",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_posedge,
	 TimingData		=> Tmkr_E_CLK_posedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_posedge,
	 SetupLow		=> tsetup_E_CLK_negedge_posedge,
	 HoldHigh		=> thold_E_CLK_posedge_posedge,
	 HoldLow		=> thold_E_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) AND (CLR_ipd)) ) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFEG",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_posedge,
	 TimingData		=> Tmkr_PRE_CLK_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_posedge,
	 Removal		=> thold_PRE_CLK_posedge_posedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TO_X01((CLR_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFEG",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_posedge,
	 Removal               => thold_CLR_CLK_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01((PRE_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFEG",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) AND (CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFEG",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "DFEG",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DFEG",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_PRE_CLK_posedge or 
	 Pviol_PRE or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_delayed, Q_zd, D_delayed, E_delayed, PRE_ipd, CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFEG_VITAL of DFEG is
   for VITAL_ACT
   end for;
end CFG_DFEG_VITAL;



 ---- CELL DFEH ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFEH is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFEH :  entity is TRUE;
 end DFEH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFEH is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,CLR_ipd,E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFEH",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_negedge,
	 TimingData		=> Tmkr_E_CLK_negedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_negedge,
	 SetupLow		=> tsetup_E_CLK_negedge_negedge,
	 HoldHigh		=> thold_E_CLK_posedge_negedge,
	 HoldLow		=> thold_E_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) AND (CLR_ipd)) ) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFEH",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_negedge,
	 TimingData		=> Tmkr_PRE_CLK_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_negedge,
	 Removal		=> thold_PRE_CLK_posedge_negedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TO_X01((CLR_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFEH",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_negedge,
	 TimingData             => Tmkr_CLR_CLK_negedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_negedge,
	 Removal               => thold_CLR_CLK_posedge_negedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01((PRE_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFEH",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) AND (CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFEH",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "DFEH",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DFEH",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Tviol_PRE_CLK_negedge or 
	 Pviol_PRE or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_ipd, Q_zd, D_delayed, E_delayed, PRE_ipd, CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFEH_VITAL of DFEH is
   for VITAL_ACT
   end for;
end CFG_DFEH_VITAL;



 ---- CELL DFP1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFP1 is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFP1 :  entity is TRUE;
 end DFP1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFP1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT PRE_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_posedge,
	 TimingData		=> Tmkr_PRE_CLK_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_negedge_posedge,
	 Removal		=> thold_PRE_CLK_negedge_posedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  TRUE,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((NOT PRE_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_PRE_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 			         TRUE,
	 HeaderMsg		=> InstancePath & "DFP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_PRE_CLK_posedge or 
	 Tviol_PRE_CLK_posedge or Pviol_PRE or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, Q_zd, D_delayed, '0', (NOT PRE_ipd), CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFP1_VITAL of DFP1 is
   for VITAL_ACT
   end for;
end CFG_DFP1_VITAL;



 ---- CELL DFP1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFP1A is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFP1A :  entity is TRUE;
 end DFP1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFP1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT PRE_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFP1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_negedge,
	 TimingData		=> Tmkr_PRE_CLK_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_negedge_negedge,
	 Removal		=> thold_PRE_CLK_negedge_negedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  TRUE,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFP1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((NOT PRE_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFP1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_PRE_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 			         TRUE,
	 HeaderMsg		=> InstancePath & "DFP1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Tviol_PRE_CLK_negedge or 
	 Tviol_PRE_CLK_negedge or Pviol_PRE or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_ipd, Q_zd, D_delayed, '0', (NOT PRE_ipd), CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFP1A_VITAL of DFP1A is
   for VITAL_ACT
   end for;
end CFG_DFP1A_VITAL;



 ---- CELL DFP1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFP1B is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFP1B :  entity is TRUE;
 end DFP1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFP1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFP1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_posedge,
	 TimingData		=> Tmkr_PRE_CLK_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_posedge,
	 Removal		=> thold_PRE_CLK_posedge_posedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TRUE,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFP1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFP1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 			         TRUE,
	 HeaderMsg		=> InstancePath & "DFP1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_PRE_CLK_posedge or 
	 Pviol_PRE or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, Q_zd, D_delayed, '0', PRE_ipd, CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFP1B_VITAL of DFP1B is
   for VITAL_ACT
   end for;
end CFG_DFP1B_VITAL;



 ---- CELL DFP1B_CC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFP1B_CC is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFP1B_CC :  entity is TRUE;
 end DFP1B_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFP1B_CC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFP1B_CC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_posedge,
	 TimingData		=> Tmkr_PRE_CLK_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_posedge,
	 Removal		=> thold_PRE_CLK_posedge_posedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TRUE,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFP1B_CC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFP1B_CC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 			         TRUE,
	 HeaderMsg		=> InstancePath & "DFP1B_CC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_PRE_CLK_posedge or 
	 Pviol_PRE or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_delayed, Q_zd, D_delayed, '0', PRE_ipd, CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFP1B_CC_VITAL of DFP1B_CC is
   for VITAL_ACT
   end for;
end CFG_DFP1B_CC_VITAL;



 ---- CELL DFP1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFP1D is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFP1D :  entity is TRUE;
 end DFP1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFP1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFP1D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_negedge,
	 TimingData		=> Tmkr_PRE_CLK_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_negedge,
	 Removal		=> thold_PRE_CLK_posedge_negedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TRUE,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFP1D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFP1D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 			         TRUE,
	 HeaderMsg		=> InstancePath & "DFP1D",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Tviol_PRE_CLK_negedge or 
	 Pviol_PRE or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             '1', CLK_ipd, Q_zd, D_delayed, '0', PRE_ipd, CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFP1D_VITAL of DFP1D is
   for VITAL_ACT
   end for;
end CFG_DFP1D_VITAL;



 ---- CELL DFPC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFPC is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFPC :  entity is TRUE;
 end DFPC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFPC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (NOT PRE_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFPC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_posedge,
	 TimingData		=> Tmkr_PRE_CLK_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_negedge_posedge,
	 Removal		=> thold_PRE_CLK_negedge_posedge,
	 ActiveLow		 => FALSE,
	 CheckEnabled           =>  TO_X01((CLR_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFPC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_posedge,
	 Removal               => thold_CLR_CLK_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01(( NOT PRE_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFPC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((NOT PRE_ipd) AND (CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFPC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "DFPC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh		=> tpw_PRE_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DFPC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_PRE_CLK_posedge or 
	 Tviol_PRE_CLK_posedge or Pviol_PRE or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_delayed, Q_zd, D_delayed, '0', (NOT PRE_ipd), CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFPC_VITAL of DFPC is
   for VITAL_ACT
   end for;
end CFG_DFPC_VITAL;



 ---- CELL DFPCB ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFPCB is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFPCB :  entity is TRUE;
 end DFPCB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFPCB is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DFPCB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_posedge,
	 TimingData		=> Tmkr_PRE_CLK_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_posedge,
	 Removal		=> thold_PRE_CLK_posedge_posedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TO_X01((CLR_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFPCB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_posedge,
	 Removal               => thold_CLR_CLK_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01((PRE_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DFPCB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) AND (CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFPCB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "DFPCB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DFPCB",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_posedge or 
	 Tviol_PRE_CLK_posedge or 
	 Pviol_PRE or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_delayed, Q_zd, D_delayed, '0', PRE_ipd, CLK_ipd));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFPCB_VITAL of DFPCB is
   for VITAL_ACT
   end for;
end CFG_DFPCB_VITAL;



 ---- CELL DFPCC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DFPCC is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DFPCC :  entity is TRUE;
 end DFPCC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DFPCC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PRE_ipd,CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE D_delayed	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DFPCC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_negedge,
	 TimingData		=> Tmkr_PRE_CLK_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_negedge,
	 Removal		=> thold_PRE_CLK_posedge_negedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TO_X01((CLR_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFPCC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_negedge,
	 TimingData             => Tmkr_CLR_CLK_negedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_negedge,
	 Removal               => thold_CLR_CLK_posedge_negedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01((PRE_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DFPCC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) AND (CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "DFPCC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "DFPCC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DFPCC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_CLK_negedge or 
	 Tviol_PRE_CLK_negedge or 
	 Pviol_PRE or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_ipd, Q_zd, D_delayed, '0', PRE_ipd, CLK_delayed));
   Q_zd := Violation XOR Q_zd;
   D_delayed := D_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DFPCC_VITAL of DFPCC is
   for VITAL_ACT
   end for;
end CFG_DFPCC_VITAL;



 ---- CELL DL1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DL1 is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DL1 :  entity is TRUE;
 end DL1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DL1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_negedge,
	 TimingData		=> Tmkr_D_G_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_negedge,
	 SetupLow		=> tsetup_D_G_negedge_negedge,
	 HoldHigh		=> thold_D_G_posedge_negedge,
	 HoldLow		=> thold_D_G_negedge_negedge,
	 CheckEnabled		=>  TRUE, 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DL1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_negedge,
	 PulseWidthHigh		=> tpw_G_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TRUE, 
	 HeaderMsg		=> InstancePath & "DL1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_negedge or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',(NOT G_ipd),D_ipd,'0'));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		    1 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DL1_VITAL of DL1 is
   for VITAL_ACT
   end for;
end CFG_DL1_VITAL;



 ---- CELL DL1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DL1B is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DL1B :  entity is TRUE;
 end DL1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DL1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_posedge,
	 TimingData		=> Tmkr_D_G_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_posedge,
	 SetupLow		=> tsetup_D_G_negedge_posedge,
	 HoldHigh		=> thold_D_G_posedge_posedge,
	 HoldLow		=> thold_D_G_negedge_posedge,
	 CheckEnabled		=>  TRUE, 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DL1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_G_negedge,
	 CheckEnabled		=>  TRUE, 
	 HeaderMsg		=> InstancePath & "DL1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_posedge or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',G_ipd,D_ipd,'0'));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		    1 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DL1B_VITAL of DL1B is
   for VITAL_ACT
   end for;
end CFG_DL1B_VITAL;



 ---- CELL DL2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DL2A is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DL2A :  entity is TRUE;
 end DL2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DL2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, PRE_ipd,CLR_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_G_negedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_G_negedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_negedge,
	 TimingData		=> Tmkr_D_G_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_negedge,
	 SetupLow		=> tsetup_D_G_negedge_negedge,
	 HoldHigh		=> thold_D_G_posedge_negedge,
	 HoldLow		=> thold_D_G_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) OR (PRE_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DL2A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_G_negedge,
	 TimingData		=> Tmkr_CLR_G_negedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_G_posedge_negedge,
	 Removal                => thold_CLR_G_posedge_negedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled		=>  TO_X01(( NOT PRE_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DL2A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_G_negedge,
	 TimingData		=> Tmkr_PRE_G_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_G_negedge_negedge,
	 Removal		=> thold_PRE_G_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01((CLR_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DL2A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_negedge,
	 PulseWidthHigh		=> tpw_G_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (NOT PRE_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DL2A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "DL2A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_PRE_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DL2A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_negedge or Tviol_PRE_G_negedge or Pviol_PRE or 
		       Pviol_CLR or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => DL2A_Q_tab,
	 DataIn => (
		CLR_ipd,D_ipd,PRE_ipd,G_ipd));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		    2 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    3 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DL2A_VITAL of DL2A is
   for VITAL_ACT
   end for;
end CFG_DL2A_VITAL;



 ---- CELL DL2C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DL2C is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DL2C :  entity is TRUE;
 end DL2C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DL2C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, PRE_ipd,CLR_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_G_posedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_G_posedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_posedge,
	 TimingData		=> Tmkr_D_G_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_posedge,
	 SetupLow		=> tsetup_D_G_negedge_posedge,
	 HoldHigh		=> thold_D_G_posedge_posedge,
	 HoldLow		=> thold_D_G_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) OR (PRE_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DL2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_G_posedge,
	 TimingData		=> Tmkr_CLR_G_posedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_G_posedge_posedge,
	 Removal                => thold_CLR_G_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled		=>  TO_X01(( NOT PRE_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DL2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_G_posedge,
	 TimingData		=> Tmkr_PRE_G_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_G_negedge_posedge,
	 Removal		=> thold_PRE_G_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01((CLR_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DL2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_G_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (NOT PRE_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DL2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "DL2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_PRE_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "DL2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_posedge or Tviol_PRE_G_posedge or Pviol_PRE or 
		       Pviol_CLR or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		CLR_ipd,G_ipd,D_ipd,PRE_ipd));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		    2 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    3 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DL2C_VITAL of DL2C is
   for VITAL_ACT
   end for;
end CFG_DL2C_VITAL;



 ---- CELL DLC ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLC is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLC :  entity is TRUE;
 end DLC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLC is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, CLR_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_G_negedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_G_negedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_negedge,
	 TimingData		=> Tmkr_D_G_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_negedge,
	 SetupLow		=> tsetup_D_G_negedge_negedge,
	 HoldHigh		=> thold_D_G_posedge_negedge,
	 HoldLow		=> thold_D_G_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_G_negedge,
	 TimingData		=> Tmkr_CLR_G_negedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_G_posedge_negedge,
	 Removal                => thold_CLR_G_posedge_negedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled		=>  TRUE,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_negedge,
	 PulseWidthHigh		=> tpw_G_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "DLC",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_negedge or Pviol_CLR or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		CLR_ipd,(NOT G_ipd),D_ipd,'0'));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		    1 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    2 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLC_VITAL of DLC is
   for VITAL_ACT
   end for;
end CFG_DLC_VITAL;



 ---- CELL DLC1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLC1 is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLC1 :  entity is TRUE;
 end DLC1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLC1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, CLR_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_G_negedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_G_negedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_negedge,
	 TimingData		=> Tmkr_D_G_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_negedge,
	 SetupLow		=> tsetup_D_G_negedge_negedge,
	 HoldHigh		=> thold_D_G_posedge_negedge,
	 HoldLow		=> thold_D_G_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DLC1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_G_negedge,
	 TimingData		=> Tmkr_CLR_G_negedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_G_negedge_negedge,
	 Removal		=> thold_CLR_G_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TRUE,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DLC1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_negedge,
	 PulseWidthHigh		=> tpw_G_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLC1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "DLC1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_negedge or Pviol_CLR or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		 (NOT CLR_ipd),(NOT G_ipd),D_ipd,'0'));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		    1 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    2 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLC1_VITAL of DLC1 is
   for VITAL_ACT
   end for;
end CFG_DLC1_VITAL;



 ---- CELL DLC1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLC1A is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLC1A :  entity is TRUE;
 end DLC1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLC1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, CLR_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_G_posedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_G_posedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_posedge,
	 TimingData		=> Tmkr_D_G_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_posedge,
	 SetupLow		=> tsetup_D_G_negedge_posedge,
	 HoldHigh		=> thold_D_G_posedge_posedge,
	 HoldLow		=> thold_D_G_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DLC1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_G_posedge,
	 TimingData		=> Tmkr_CLR_G_posedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_G_negedge_posedge,
	 Removal		=> thold_CLR_G_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TRUE,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DLC1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_G_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLC1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "DLC1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_posedge or Pviol_CLR or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		 (NOT CLR_ipd),G_ipd,D_ipd,'0'));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		    1 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    2 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLC1A_VITAL of DLC1A is
   for VITAL_ACT
   end for;
end CFG_DLC1A_VITAL;



 ---- CELL DLCA ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLCA is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLCA :  entity is TRUE;
 end DLCA;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLCA is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, CLR_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_G_posedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_G_posedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_posedge,
	 TimingData		=> Tmkr_D_G_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_posedge,
	 SetupLow		=> tsetup_D_G_negedge_posedge,
	 HoldHigh		=> thold_D_G_posedge_posedge,
	 HoldLow		=> thold_D_G_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DLCA",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_G_posedge,
	 TimingData		=> Tmkr_CLR_G_posedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_G_posedge_posedge,
	 Removal                => thold_CLR_G_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled		=>  TRUE,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DLCA",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_G_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLCA",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "DLCA",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_posedge or Pviol_CLR or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		CLR_ipd,G_ipd,D_ipd,'0'));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		    1 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    2 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLCA_VITAL of DLCA is
   for VITAL_ACT
   end for;
end CFG_DLCA_VITAL;



 ---- CELL DLE2C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLE2C is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLE2C :  entity is TRUE;
 end DLE2C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLE2C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (E_ipd,E, tipd_E);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, CLR_ipd,E_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_D_E_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_E_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tviol_E_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_E_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tmkr_E_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_G_posedge	: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_G_posedge         : VitalTimingDataType	:= VitalTimingDataInit;
	VARIABLE Tviol_CLR_E_posedge : STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_E_posedge         : VitalTimingDataType   := VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_E		: STD_ULOGIC := '0';
	VARIABLE PInfo_E		: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_posedge,
	 TimingData		=> Tmkr_D_G_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_posedge,
	 SetupLow		=> tsetup_D_G_negedge_posedge,
	 HoldHigh		=> thold_D_G_posedge_posedge,
	 HoldLow		=> thold_D_G_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) OR (E_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DLE2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_E_posedge,
	 TimingData		=> Tmkr_D_E_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> E_ipd,
	 RefSignalName		=> "E",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_E_posedge_posedge,
	 SetupLow		=> tsetup_D_E_negedge_posedge,
	 HoldHigh               => thold_D_E_posedge_posedge,
	 HoldLow		=> thold_D_E_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) OR (G_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DLE2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_E_G_posedge,
	 TimingData             => Tmkr_E_G_posedge,
	 TestSignal             => E_ipd,
	 TestSignalName         => "E",
	 TestDelay              => 0 ns,
	 RefSignal              => G_ipd,
	 RefSignalName          => "G",
	 RefDelay               => 0 ns,
	 SetupHigh              => 0 ns,
	 SetupLow               => 0 ns,
	 HoldHigh               => 0 ns,
	 HoldLow                => thold_E_G_posedge_posedge,
	 CheckEnabled           =>  TO_X01(((CLR_ipd) ) ) /= '1', 
	 RefTransition          => 'R',
	 HeaderMsg              => InstancePath & "/DLE2C",
	 Xon            => Xon,
	 MsgOn          => MsgOn,
	 MsgSeverity            => WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_E_G_negedge,
	 TimingData             => Tmkr_E_G_negedge,
	 TestSignal             => E_ipd,
	 TestSignalName         => "E",
	 TestDelay              => 0 ns,
	 RefSignal              => G_ipd,
	 RefSignalName          => "G",
	 RefDelay               => 0 ns,
	 SetupHigh              => 0 ns,
	 SetupLow              => tsetup_E_G_negedge_negedge,
	 HoldHigh               => 0 ns,
	 HoldLow                => 0 ns,
	 CheckEnabled           =>  TO_X01(((CLR_ipd) ) ) /= '1', 
	 RefTransition          => 'F',
	 HeaderMsg              => InstancePath & "/DLE2C",
	 Xon            => Xon,
	 MsgOn          => MsgOn,
	 MsgSeverity            => WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_G_posedge,
	 TimingData		=> Tmkr_CLR_G_posedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_G_negedge_posedge,
	 Removal		=> thold_CLR_G_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01((NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DLE2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_E_posedge,
	 TimingData		=> Tmkr_CLR_E_posedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> E_ipd,
	 RefSignalName		=> "E",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_E_negedge_posedge,
	 Removal		=> thold_CLR_E_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled           =>  TO_X01((NOT G_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DLE2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_G_negedge,
	 CheckEnabled		=>  TO_X01(((NOT CLR_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLE2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_E,
	 PeriodData		=> PInfo_E,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 Period	        	=> 0 ns,
         PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_E_negedge,
	 CheckEnabled		=> TO_X01((CLR_ipd)) /= '1',
	 HeaderMsg		=> InstancePath & "DLE2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_CLR_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "DLE2C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_posedge or Tviol_D_E_posedge or Pviol_CLR or 
		      Pviol_E or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DLE2B_Q_tab,
	 DataIn => (
		    (NOT CLR_ipd),G_ipd,E_ipd,D_ipd));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 =>(E_ipd'last_event, tpd_E_Q, true),
		    2 => (CLR_ipd'last_event, tpd_CLR_Q, true),
		    3 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLE2C_VITAL of DLE2C is
   for VITAL_ACT
   end for;
end CFG_DLE2C_VITAL;



 ---- CELL DLE3B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLE3B is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLE3B :  entity is TRUE;
 end DLE3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLE3B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	VitalWireDelay (E_ipd,E, tipd_E);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, PRE_ipd,E_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_D_E_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_E_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tviol_E_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_E_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tmkr_E_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_E_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_E_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_E		: STD_ULOGIC := '0';
	VARIABLE PInfo_E		: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_posedge,
	 TimingData		=> Tmkr_D_G_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_posedge,
	 SetupLow		=> tsetup_D_G_negedge_posedge,
	 HoldHigh		=> thold_D_G_posedge_posedge,
	 HoldLow		=> thold_D_G_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) OR (E_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DLE3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_E_posedge,
	 TimingData		=> Tmkr_D_E_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> E_ipd,
	 RefSignalName		=> "E",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_E_posedge_posedge,
	 SetupLow		=> tsetup_D_E_negedge_posedge,
	 HoldHigh               => thold_D_E_posedge_posedge,
	 HoldLow		=> thold_D_E_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) OR (G_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DLE3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_E_G_posedge,
	 TimingData             => Tmkr_E_G_posedge,
	 TestSignal             => E_ipd,
	 TestSignalName         => "E",
	 TestDelay              => 0 ns,
	 RefSignal              => G_ipd,
	 RefSignalName          => "G",
	 RefDelay               => 0 ns,
	 SetupHigh              => 0 ns,
	 SetupLow               => 0 ns,
	 HoldHigh               => 0 ns,
	 HoldLow                => thold_E_G_posedge_posedge,
	 CheckEnabled           =>  TO_X01(((PRE_ipd) ) ) /= '1', 
	 RefTransition          => 'R',
	 HeaderMsg              => InstancePath & "/DLE3B",
	 Xon            => Xon,
	 MsgOn          => MsgOn,
	 MsgSeverity            => WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_E_G_negedge,
	 TimingData             => Tmkr_E_G_negedge,
	 TestSignal             => E_ipd,
	 TestSignalName         => "E",
	 TestDelay              => 0 ns,
	 RefSignal              => G_ipd,
	 RefSignalName          => "G",
	 RefDelay               => 0 ns,
	 SetupHigh              => 0 ns,
	 SetupLow              => tsetup_E_G_negedge_negedge,
	 HoldHigh               => 0 ns,
	 HoldLow                => 0 ns,
	 CheckEnabled           =>  TO_X01(((PRE_ipd) ) ) /= '1', 
	 RefTransition          => 'F',
	 HeaderMsg              => InstancePath & "/DLE3B",
	 Xon            => Xon,
	 MsgOn          => MsgOn,
	 MsgSeverity            => WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_G_posedge,
	 TimingData		=> Tmkr_PRE_G_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_G_negedge_posedge,
	 Removal		=> thold_PRE_G_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TO_X01((NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DLE3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_E_posedge,
	 TimingData		=> Tmkr_PRE_E_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> E_ipd,
	 RefSignalName		=> "E",
	 RefDelay	 => 0 ns,
	 Recovery	 => trecovery_PRE_E_negedge_posedge,
	 Removal		=> thold_PRE_E_negedge_posedge,
	 ActiveLow		=> FALSE,
         CheckEnabled		=>  TO_X01((NOT G_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DLE3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_G_negedge,
	 CheckEnabled		=>  TO_X01(((NOT PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLE3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_E,
	 PeriodData		=> PInfo_E,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 Period	        	=> 0 ns,
         PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_E_negedge,
	 CheckEnabled		=> TO_X01( (PRE_ipd)) /= '1',
	 HeaderMsg		=> InstancePath & "DLE3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_PRE_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 	TRUE,
	 HeaderMsg		=> InstancePath & "DLE3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_posedge or Tviol_D_E_posedge or Tviol_PRE_G_posedge or 
		      Pviol_PRE or Pviol_E or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DLE3B_Q_tab,
	 DataIn => (
		  G_ipd,E_ipd,D_ipd,PRE_ipd));

	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 =>(E_ipd'last_event, tpd_E_Q, true),
		     2 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		    3 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLE3B_VITAL of DLE3B is
   for VITAL_ACT
   end for;
end CFG_DLE3B_VITAL;



 ---- CELL DLE3C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLE3C is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLE3C :  entity is TRUE;
 end DLE3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLE3C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	VitalWireDelay (E_ipd,E, tipd_E);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, PRE_ipd,E_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_D_E_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_E_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tviol_E_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_E_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tmkr_E_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_E_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_E_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_E		: STD_ULOGIC := '0';
	VARIABLE PInfo_E		: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_posedge,
	 TimingData		=> Tmkr_D_G_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_posedge,
	 SetupLow		=> tsetup_D_G_negedge_posedge,
	 HoldHigh		=> thold_D_G_posedge_posedge,
	 HoldLow		=> thold_D_G_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT PRE_ipd) OR (E_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DLE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_E_posedge,
	 TimingData		=> Tmkr_D_E_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> E_ipd,
	 RefSignalName		=> "E",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_E_posedge_posedge,
	 SetupLow		=> tsetup_D_E_negedge_posedge,
	 HoldHigh               => thold_D_E_posedge_posedge,
	 HoldLow		=> thold_D_E_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT PRE_ipd) OR (G_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DLE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_E_G_posedge,
	 TimingData             => Tmkr_E_G_posedge,
	 TestSignal             => E_ipd,
	 TestSignalName         => "E",
	 TestDelay              => 0 ns,
	 RefSignal              => G_ipd,
	 RefSignalName          => "G",
	 RefDelay               => 0 ns,
	 SetupHigh              => 0 ns,
	 SetupLow               => 0 ns,
	 HoldHigh               => 0 ns,
	 HoldLow                => thold_E_G_posedge_posedge,
	 CheckEnabled           =>  TO_X01(((NOT PRE_ipd) ) ) /= '1', 
	 RefTransition          => 'R',
	 HeaderMsg              => InstancePath & "/DLE3C",
	 Xon            => Xon,
	 MsgOn          => MsgOn,
	 MsgSeverity            => WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_E_G_negedge,
	 TimingData             => Tmkr_E_G_negedge,
	 TestSignal             => E_ipd,
	 TestSignalName         => "E",
	 TestDelay              => 0 ns,
	 RefSignal              => G_ipd,
	 RefSignalName          => "G",
	 RefDelay               => 0 ns,
	 SetupHigh              => 0 ns,
	 SetupLow              => tsetup_E_G_negedge_negedge,
	 HoldHigh               => 0 ns,
	 HoldLow                => 0 ns,
	 CheckEnabled           =>  TO_X01(((NOT PRE_ipd) ) ) /= '1', 
	 RefTransition          => 'F',
	 HeaderMsg              => InstancePath & "/DLE3C",
	 Xon            => Xon,
	 MsgOn          => MsgOn,
	 MsgSeverity            => WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_G_posedge,
	 TimingData		=> Tmkr_PRE_G_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_G_posedge_posedge,
	 Removal                => thold_PRE_G_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled		=>  TO_X01((NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DLE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_E_posedge,
	 TimingData		=> Tmkr_PRE_E_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> E_ipd,
	 RefSignalName		=> "E",
	 RefDelay	 => 0 ns,
	 Recovery	 => trecovery_PRE_E_posedge_posedge,
	 Removal                => thold_PRE_E_posedge_posedge,
	 ActiveLow		=> TRUE,
         CheckEnabled		=>  TO_X01((NOT G_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DLE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_G_negedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_E,
	 PeriodData		=> PInfo_E,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 Period	        	=> 0 ns,
         PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_E_negedge,
	 CheckEnabled		=> TO_X01( (NOT PRE_ipd)) /= '1',
	 HeaderMsg		=> InstancePath & "DLE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthLow		=> tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 	TRUE,
	 HeaderMsg		=> InstancePath & "DLE3C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_posedge or Tviol_D_E_posedge or Tviol_PRE_G_posedge or 
		      Pviol_PRE or Pviol_E or Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DLE3B_Q_tab,
	 DataIn => (
		  G_ipd,E_ipd,D_ipd,(NOT PRE_ipd)));

	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 =>(E_ipd'last_event, tpd_E_Q, true),
		     2 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		    3 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLE3C_VITAL of DLE3C is
   for VITAL_ACT
   end for;
end CFG_DLE3C_VITAL;



 ---- CELL DLP1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLP1 is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLP1 :  entity is TRUE;
 end DLP1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLP1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, PRE_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_negedge,
	 TimingData		=> Tmkr_D_G_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_negedge,
	 SetupLow		=> tsetup_D_G_negedge_negedge,
	 HoldHigh		=> thold_D_G_posedge_negedge,
	 HoldLow		=> thold_D_G_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DLP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_G_negedge,
	 TimingData		=> Tmkr_PRE_G_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_G_negedge_negedge,
	 Removal		=> thold_PRE_G_negedge_negedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TRUE,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DLP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_negedge,
	 PulseWidthHigh		=> tpw_G_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((NOT PRE_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_PRE_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 	TRUE,
	 HeaderMsg		=> InstancePath & "DLP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_negedge or Tviol_PRE_G_negedge or Pviol_PRE or 
		       Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',(NOT G_ipd),D_ipd,PRE_ipd));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		    2 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLP1_VITAL of DLP1 is
   for VITAL_ACT
   end for;
end CFG_DLP1_VITAL;



 ---- CELL DLP1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLP1A is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLP1A :  entity is TRUE;
 end DLP1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLP1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, PRE_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_posedge,
	 TimingData		=> Tmkr_D_G_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_posedge,
	 SetupLow		=> tsetup_D_G_negedge_posedge,
	 HoldHigh		=> thold_D_G_posedge_posedge,
	 HoldLow		=> thold_D_G_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DLP1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_G_posedge,
	 TimingData		=> Tmkr_PRE_G_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_G_negedge_posedge,
	 Removal		=> thold_PRE_G_negedge_posedge,
	 ActiveLow		=> FALSE,
	 CheckEnabled		=>  TRUE,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DLP1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_G_negedge,
	 CheckEnabled		=>  TO_X01(((NOT PRE_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLP1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthHigh		=> tpw_PRE_posedge,
	 PulseWidthLow		=> 0 ns,
	 CheckEnabled		=> 	TRUE,
	 HeaderMsg		=> InstancePath & "DLP1A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_posedge or Tviol_PRE_G_posedge or Pviol_PRE or 
		       Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',G_ipd,D_ipd,PRE_ipd));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		    2 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLP1A_VITAL of DLP1A is
   for VITAL_ACT
   end for;
end CFG_DLP1A_VITAL;



 ---- CELL DLP1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLP1B is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLP1B :  entity is TRUE;
 end DLP1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLP1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, PRE_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_G_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_G_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_negedge,
	 TimingData		=> Tmkr_D_G_negedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_negedge,
	 SetupLow		=> tsetup_D_G_negedge_negedge,
	 HoldHigh		=> thold_D_G_posedge_negedge,
	 HoldLow		=> thold_D_G_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((NOT PRE_ipd) ) ) /= '1', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/DLP1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_G_negedge,
	 TimingData		=> Tmkr_PRE_G_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_G_posedge_negedge,
	 Removal                => thold_PRE_G_posedge_negedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled		=>  TRUE,
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "DLP1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_negedge,
	 PulseWidthHigh		=> tpw_G_posedge,
	 PulseWidthLow          => 0 ns,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLP1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthLow		=> tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 	TRUE,
	 HeaderMsg		=> InstancePath & "DLP1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_negedge or Tviol_PRE_G_negedge or Pviol_PRE or 
		       Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',(NOT G_ipd),D_ipd,(NOT PRE_ipd)));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		    2 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLP1B_VITAL of DLP1B is
   for VITAL_ACT
   end for;
end CFG_DLP1B_VITAL;



 ---- CELL DLP1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity DLP1C is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of DLP1C :  entity is TRUE;
 end DLP1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of DLP1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	VitalWireDelay (G_ipd,G, tipd_G);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
	VITALBehavior : process (D_ipd, PRE_ipd,G_ipd)

	-- timing check results
	VARIABLE Tviol_D_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_D_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_G_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_G_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_G	: STD_ULOGIC := '0';
	VARIABLE PInfo_G	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q	: STD_LOGIC_VECTOR(0 to 3);
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)	:= (others => 'X');
	ALIAS Q_zd	:  STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Q_GlitchData	: VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_G_posedge,
	 TimingData		=> Tmkr_D_G_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_G_posedge_posedge,
	 SetupLow		=> tsetup_D_G_negedge_posedge,
	 HoldHigh		=> thold_D_G_posedge_posedge,
	 HoldLow		=> thold_D_G_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((NOT PRE_ipd) ) ) /= '1', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/DLP1C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_G_posedge,
	 TimingData		=> Tmkr_PRE_G_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> G_ipd,
	 RefSignalName		=> "G",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_G_posedge_posedge,
	 Removal                => thold_PRE_G_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled		=>  TRUE,
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "DLP1C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_G,
	 PeriodData		=> PInfo_G,
	 TestSignal		=> G_ipd,
	 TestSignalName		=> "G",
	 TestDelay		=> 0 ns,
	 Period		 => tperiod_G_posedge,
	 PulseWidthHigh         => 0 ns,
	 PulseWidthLow		=> tpw_G_negedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) ) ) /= '0', 
	 HeaderMsg		=> InstancePath & "DLP1C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		        => 0 ns,
	 PulseWidthLow		=> tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 	TRUE,
	 HeaderMsg		=> InstancePath & "DLP1C",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_D_G_posedge or Tviol_PRE_G_posedge or Pviol_PRE or 
		       Pviol_G;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => dlatch_DL2C_Q_tab,
	 DataIn => (
		'1',G_ipd,D_ipd,(NOT PRE_ipd)));
	 Q_zd := Violation XOR Q_zd;
	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (D_ipd'last_event, tpd_D_Q, true),
		     1 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		    2 => (G_ipd'last_event, tpd_G_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_DLP1C_VITAL of DLP1C is
   for VITAL_ACT
   end for;
end CFG_DLP1C_VITAL;



 ---- CELL FA1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity FA1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CI_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CI_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CI		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		CI		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of FA1 :  entity is TRUE;
 end FA1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of FA1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL CI_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (CI_ipd, CI, tipd_CI);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, CI_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS S_zd : STD_LOGIC is Results(1);
	ALIAS CO_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE S_GlitchData  : VitalGlitchDataType;
	VARIABLE CO_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       S_zd := ( VitalMUX2( B_ipd , (NOT B_ipd) , (NOT A_ipd) ) XOR  CI_ipd );
       CO_zd := ((( A_ipd  AND  B_ipd ) OR ( A_ipd  AND  CI_ipd )) OR ( B_ipd  AND  CI_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => S,
	   GlitchData => S_GlitchData,
	   OutSignalName => "S",
	   OutTemp => S_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_S, true),
	             1 => (B_ipd'last_event,tpd_B_S, true),
	             2 => (CI_ipd'last_event,tpd_CI_S, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => CO,
	   GlitchData => CO_GlitchData,
	   OutSignalName => "CO",
	   OutTemp => CO_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_CO, true),
	             1 => (B_ipd'last_event,tpd_B_CO, true),
	             2 => (CI_ipd'last_event,tpd_CI_CO, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_FA1_VITAL of FA1 is 
    for VITAL_ACT
    end for;
 end CFG_FA1_VITAL;



 ---- CELL GAND2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GAND2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GAND2 :  entity is TRUE;
 end GAND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of GAND2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (G_ipd, G, tipd_G);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, G_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( A_ipd  AND  G_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (G_ipd'last_event,tpd_G_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GAND2_VITAL of GAND2 is 
    for VITAL_ACT
    end for;
 end CFG_GAND2_VITAL;



 ---- CELL GMX4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GMX4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S0		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GMX4 :  entity is TRUE;
 end GMX4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of GMX4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S0_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S0_ipd, S0, tipd_S0);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (G_ipd, G, tipd_G);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S0_ipd, D1_ipd, G_ipd, D2_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , (NOT S0_ipd) ), VitalMUX2( D2_ipd , D3_ipd , (NOT S0_ipd) ), (NOT G_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S0_ipd'last_event,tpd_S0_Y, true),
	             2 => (D1_ipd'last_event,tpd_D1_Y, true),
	             3 => (G_ipd'last_event,tpd_G_Y, true),
	             4 => (D2_ipd'last_event,tpd_D2_Y, true),
	             5 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GMX4_VITAL of GMX4 is 
    for VITAL_ACT
    end for;
 end CFG_GMX4_VITAL;



 ---- CELL GNAND2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GNAND2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GNAND2 :  entity is TRUE;
 end GNAND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of GNAND2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (G_ipd, G, tipd_G);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, G_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT (  A_ipd  AND  G_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (G_ipd'last_event,tpd_G_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GNAND2_VITAL of GNAND2 is 
    for VITAL_ACT
    end for;
 end CFG_GNAND2_VITAL;



 ---- CELL GND ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GND is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GND :  entity is TRUE;
 end GND;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of GND is
	attribute VITAL_LEVEL0 of VITAL_ACT : architecture is TRUE;


begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	--- Empty
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
        Y<= '0';


end VITAL_ACT;

 configuration CFG_GND_VITAL of GND is 
    for VITAL_ACT
    end for;
 end CFG_GND_VITAL;



 ---- CELL GNOR2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GNOR2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GNOR2 :  entity is TRUE;
 end GNOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of GNOR2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (G_ipd, G, tipd_G);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, G_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT (  A_ipd  OR  G_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (G_ipd'last_event,tpd_G_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GNOR2_VITAL of GNOR2 is 
    for VITAL_ACT
    end for;
 end CFG_GNOR2_VITAL;



 ---- CELL GOR2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GOR2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GOR2 :  entity is TRUE;
 end GOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of GOR2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (G_ipd, G, tipd_G);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, G_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( A_ipd  OR  G_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (G_ipd'last_event,tpd_G_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GOR2_VITAL of GOR2 is 
    for VITAL_ACT
    end for;
 end CFG_GOR2_VITAL;



 ---- CELL GXOR2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity GXOR2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of GXOR2 :  entity is TRUE;
 end GXOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of GXOR2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL G_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (G_ipd, G, tipd_G);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, G_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( G_ipd , (NOT G_ipd) , (NOT A_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (G_ipd'last_event,tpd_G_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_GXOR2_VITAL of GXOR2 is 
    for VITAL_ACT
    end for;
 end CFG_GXOR2_VITAL;



 ---- CELL HA1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity HA1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of HA1 :  entity is TRUE;
 end HA1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of HA1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS S_zd : STD_LOGIC is Results(1);
	ALIAS CO_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE S_GlitchData  : VitalGlitchDataType;
	VARIABLE CO_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       S_zd :=  VitalMUX2( B_ipd , (NOT B_ipd) , (NOT A_ipd) );
       CO_zd := ( A_ipd  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => S,
	   GlitchData => S_GlitchData,
	   OutSignalName => "S",
	   OutTemp => S_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_S, true),
	             1 => (B_ipd'last_event,tpd_B_S, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => CO,
	   GlitchData => CO_GlitchData,
	   OutSignalName => "CO",
	   OutTemp => CO_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_CO, true),
	             1 => (B_ipd'last_event,tpd_B_CO, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_HA1_VITAL of HA1 is 
    for VITAL_ACT
    end for;
 end CFG_HA1_VITAL;



 ---- CELL HA1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity HA1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of HA1A :  entity is TRUE;
 end HA1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of HA1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS S_zd : STD_LOGIC is Results(1);
	ALIAS CO_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE S_GlitchData  : VitalGlitchDataType;
	VARIABLE CO_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       S_zd :=  VitalMUX2( B_ipd , (NOT B_ipd) , A_ipd );
       CO_zd := ( (NOT A_ipd)  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => S,
	   GlitchData => S_GlitchData,
	   OutSignalName => "S",
	   OutTemp => S_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_S, true),
	             1 => (B_ipd'last_event,tpd_B_S, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => CO,
	   GlitchData => CO_GlitchData,
	   OutSignalName => "CO",
	   OutTemp => CO_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_CO, true),
	             1 => (B_ipd'last_event,tpd_B_CO, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_HA1A_VITAL of HA1A is 
    for VITAL_ACT
    end for;
 end CFG_HA1A_VITAL;



 ---- CELL HA1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity HA1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of HA1B :  entity is TRUE;
 end HA1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of HA1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS S_zd : STD_LOGIC is Results(1);
	ALIAS CO_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE S_GlitchData  : VitalGlitchDataType;
	VARIABLE CO_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       S_zd :=  NOT VitalMUX2( B_ipd , (NOT B_ipd) , (NOT A_ipd) );
       CO_zd :=  NOT (  A_ipd  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => S,
	   GlitchData => S_GlitchData,
	   OutSignalName => "S",
	   OutTemp => S_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_S, true),
	             1 => (B_ipd'last_event,tpd_B_S, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => CO,
	   GlitchData => CO_GlitchData,
	   OutSignalName => "CO",
	   OutTemp => CO_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_CO, true),
	             1 => (B_ipd'last_event,tpd_B_CO, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_HA1B_VITAL of HA1B is 
    for VITAL_ACT
    end for;
 end CFG_HA1B_VITAL;



 ---- CELL HA1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity HA1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of HA1C :  entity is TRUE;
 end HA1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of HA1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS S_zd : STD_LOGIC is Results(1);
	ALIAS CO_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE S_GlitchData  : VitalGlitchDataType;
	VARIABLE CO_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       S_zd :=  VitalMUX2( B_ipd , (NOT B_ipd) , (NOT A_ipd) );
       CO_zd :=  NOT (  A_ipd  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => S,
	   GlitchData => S_GlitchData,
	   OutSignalName => "S",
	   OutTemp => S_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_S, true),
	             1 => (B_ipd'last_event,tpd_B_S, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => CO,
	   GlitchData => CO_GlitchData,
	   OutSignalName => "CO",
	   OutTemp => CO_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_CO, true),
	             1 => (B_ipd'last_event,tpd_B_CO, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_HA1C_VITAL of HA1C is 
    for VITAL_ACT
    end for;
 end CFG_HA1C_VITAL;



 ---- CELL HCLKBUF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity HCLKBUF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of HCLKBUF :  entity is TRUE;
 end HCLKBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of HCLKBUF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_HCLKBUF_VITAL of HCLKBUF is 
    for VITAL_ACT
    end for;
 end CFG_HCLKBUF_VITAL;



 ---- CELL INBUF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity INBUF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of INBUF :  entity is TRUE;
 end INBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of INBUF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_INBUF_VITAL of INBUF is 
    for VITAL_ACT
    end for;
 end CFG_INBUF_VITAL;



 ---- CELL INV ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity INV is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of INV :  entity is TRUE;
 end INV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of INV is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  (NOT A_ipd) ;


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_INV_VITAL of INV is 
    for VITAL_ACT
    end for;
 end CFG_INV_VITAL;



 ---- CELL INVA ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity INVA is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of INVA :  entity is TRUE;
 end INVA;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of INVA is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  (NOT A_ipd) ;


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_INVA_VITAL of INVA is 
    for VITAL_ACT
    end for;
 end CFG_INVA_VITAL;



 ---- CELL INVD ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity INVD is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of INVD :  entity is TRUE;
 end INVD;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of INVD is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  (NOT A_ipd) ;


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_INVD_VITAL of INVD is 
    for VITAL_ACT
    end for;
 end CFG_INVD_VITAL;



 ---- CELL JKF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity JKF is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of JKF :  entity is FALSE;
 end JKF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of JKF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is FALSE;

	SIGNAL J_ipd  : STD_ULOGIC := 'X';
	SIGNAL K_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (J_ipd, J, tipd_J);
	VitalWireDelay (K_ipd, K, tipd_K);
	VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (J_ipd, K_ipd, CLK_ipd)

	-- timing check results
	VARIABLE Tviol_J_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_J_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_K_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_K_CLK_posedge		:  VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK  : STD_ULOGIC := '0';
	VARIABLE PInfo_CLK  : VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation      : STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 5);
	VARIABLE CLK_delayed        : STD_ULOGIC := 'X';
	VARIABLE J_delayed        : STD_ULOGIC := 'X';
	VARIABLE K_delayed        : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_J_CLK_posedge,
	 TimingData		=> Tmkr_J_CLK_posedge,
	 TestSignal		=> J_ipd,
	 TestSignalName		=> "J",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_J_CLK_posedge_posedge,
	 SetupLow		=> tsetup_J_CLK_negedge_posedge,
	 HoldHigh		=> thold_J_CLK_posedge_posedge,
	 HoldLow		=> thold_J_CLK_negedge_posedge,
	 CheckEnabled		=>  TRUE, 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/JKF",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_K_CLK_posedge,
	 TimingData             => Tmkr_K_CLK_posedge,
	 TestSignal             => K_ipd,
	 TestSignalName         => "K",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 SetupHigh              => tsetup_K_CLK_posedge_posedge,
	 SetupLow               => tsetup_K_CLK_negedge_posedge,
	 HoldHigh               => thold_K_CLK_posedge_posedge,
	 HoldLow                => thold_K_CLK_negedge_posedge,
	 CheckEnabled           =>  TRUE, 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/JKF",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh => tpw_CLK_posedge,
	 PulseWidthLow => tpw_CLK_negedge,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "JKF",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

   -------------------------
   --  Functionality Section
   -------------------------

	 Violation := Tviol_J_CLK_posedge or 
	 Tviol_K_CLK_posedge or 
   Pviol_CLK;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => JKF2A_Q_tab,
	 DataIn => (
             '1', CLK_delayed, K_delayed, J_delayed, Q_zd, CLK_ipd));
	 Q_zd := Violation XOR Q_zd;
	  --- now combinatorial logic input to the DFF 
	 J_delayed :=  J_ipd ;
          --- now combinatorial logic input to the DFF 
         K_delayed :=  (NOT K_ipd) ;
	 CLK_delayed := CLK_ipd;

	 ----------------------
	 --  Path Delay Section
	 ----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_JKF_VITAL of JKF is
   for VITAL_ACT
   end for;
end CFG_JKF_VITAL;



 ---- CELL JKF1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity JKF1B is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of JKF1B :  entity is FALSE;
 end JKF1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of JKF1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is FALSE;

	SIGNAL J_ipd  : STD_ULOGIC := 'X';
	SIGNAL K_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (J_ipd, J, tipd_J);
	VitalWireDelay (K_ipd, K, tipd_K);
	VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (J_ipd, K_ipd, CLK_ipd)

	-- timing check results
	VARIABLE Tviol_J_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_J_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_K_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_K_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK  : STD_ULOGIC := '0';
	VARIABLE PInfo_CLK  : VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation      : STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 5);
	VARIABLE CLK_delayed        : STD_ULOGIC := 'X';
	VARIABLE J_delayed        : STD_ULOGIC := 'X';
	VARIABLE K_delayed        : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_J_CLK_negedge,
	 TimingData		=> Tmkr_J_CLK_negedge,
	 TestSignal		=> J_ipd,
	 TestSignalName		=> "J",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_J_CLK_posedge_negedge,
	 SetupLow		=> tsetup_J_CLK_negedge_negedge,
	 HoldHigh		=> thold_J_CLK_posedge_negedge,
	 HoldLow		=> thold_J_CLK_negedge_negedge,
	 CheckEnabled		=>  TRUE, 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/JKF1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_K_CLK_negedge,
	 TimingData             => Tmkr_K_CLK_negedge,
	 TestSignal             => K_ipd,
	 TestSignalName         => "K",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 SetupHigh              => tsetup_K_CLK_posedge_negedge,
	 SetupLow               => tsetup_K_CLK_negedge_negedge,
	 HoldHigh               => thold_K_CLK_posedge_negedge,
	 HoldLow                => thold_K_CLK_negedge_negedge,
	 CheckEnabled           =>  TRUE, 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/JKF1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh => tpw_CLK_negedge,
	 PulseWidthLow => tpw_CLK_posedge,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "JKF1B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

   -------------------------
   --  Functionality Section
   -------------------------

	 Violation := Tviol_J_CLK_negedge or 
	 Tviol_K_CLK_negedge or 
   Pviol_CLK;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => JKF2A_Q_tab,
	 DataIn => (
             '1', CLK_ipd, K_delayed, J_delayed, Q_zd, CLK_delayed));
	 Q_zd := Violation XOR Q_zd;
	  --- now combinatorial logic input to the DFF 
	 J_delayed :=  J_ipd ;
          --- now combinatorial logic input to the DFF 
         K_delayed :=  (NOT K_ipd) ;
	 CLK_delayed := CLK_ipd;

	 ----------------------
	 --  Path Delay Section
	 ----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_JKF1B_VITAL of JKF1B is
   for VITAL_ACT
   end for;
end CFG_JKF1B_VITAL;



 ---- CELL JKF2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity JKF2A is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tipd_CLR	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLR	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of JKF2A :  entity is FALSE;
 end JKF2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of JKF2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is FALSE;

	SIGNAL J_ipd  : STD_ULOGIC := 'X';
	SIGNAL K_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (J_ipd, J, tipd_J);
	VitalWireDelay (K_ipd, K, tipd_K);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (J_ipd, K_ipd, CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_J_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_J_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_K_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_K_CLK_posedge		:  VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK  : STD_ULOGIC := '0';
	VARIABLE PInfo_CLK  : VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR    : STD_ULOGIC := '0';
	VARIABLE PInfo_CLR    : VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation      : STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 5);
	VARIABLE CLK_delayed        : STD_ULOGIC := 'X';
	VARIABLE J_delayed        : STD_ULOGIC := 'X';
	VARIABLE K_delayed        : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_J_CLK_posedge,
	 TimingData		=> Tmkr_J_CLK_posedge,
	 TestSignal		=> J_ipd,
	 TestSignalName		=> "J",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_J_CLK_posedge_posedge,
	 SetupLow		=> tsetup_J_CLK_negedge_posedge,
	 HoldHigh		=> thold_J_CLK_posedge_posedge,
	 HoldLow		=> thold_J_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01((CLR_ipd)) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/JKF2A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_K_CLK_posedge,
	 TimingData             => Tmkr_K_CLK_posedge,
	 TestSignal             => K_ipd,
	 TestSignalName         => "K",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 SetupHigh              => tsetup_K_CLK_posedge_posedge,
	 SetupLow               => tsetup_K_CLK_negedge_posedge,
	 HoldHigh               => thold_K_CLK_posedge_posedge,
	 HoldLow                => thold_K_CLK_negedge_posedge,
	 CheckEnabled           =>  TO_X01((CLR_ipd)) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/JKF2A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_CLK_posedge,
	 TimingData		=> Tmkr_CLR_CLK_posedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_CLK_posedge_posedge,
	 Removal		=> thold_CLR_CLK_posedge_posedge,
	 ActiveLow              => TRUE,
	 CheckEnabled		=>  TRUE,
	 RefTransition          => 'R',
	 HeaderMsg              => InstancePath & "JKF2A",
	 Xon            => Xon,
	 MsgOn          => MsgOn,
	 MsgSeverity            => WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh => tpw_CLK_posedge,
	 PulseWidthLow => tpw_CLK_negedge,
	 CheckEnabled		=> TO_X01((CLR_ipd)) /= '0',
	 HeaderMsg		=> InstancePath & "JKF2A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "JKF2A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

   -------------------------
   --  Functionality Section
   -------------------------

	 Violation := Tviol_J_CLK_posedge or 
	 Tviol_K_CLK_posedge or 
   Pviol_CLR or 
	 Pviol_CLK;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => JKF2A_Q_tab,
	 DataIn => (
             CLR_ipd, CLK_delayed, K_delayed, J_delayed, Q_zd, CLK_ipd));
	 Q_zd := Violation XOR Q_zd;
	  --- now combinatorial logic input to the DFF 
	 J_delayed :=  J_ipd ;
          --- now combinatorial logic input to the DFF 
         K_delayed :=  (NOT K_ipd) ;
	 CLK_delayed := CLK_ipd;

	 ----------------------
	 --  Path Delay Section
	 ----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1 => (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_JKF2A_VITAL of JKF2A is
   for VITAL_ACT
   end for;
end CFG_JKF2A_VITAL;



 ---- CELL JKF2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity JKF2B is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge           :   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tipd_CLR	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLR	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of JKF2B :  entity is FALSE;
 end JKF2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of JKF2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is FALSE;

	SIGNAL J_ipd  : STD_ULOGIC := 'X';
	SIGNAL K_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (J_ipd, J, tipd_J);
	VitalWireDelay (K_ipd, K, tipd_K);
	VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (J_ipd, K_ipd, CLR_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_J_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_J_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_K_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_K_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK  : STD_ULOGIC := '0';
	VARIABLE PInfo_CLK  : VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR    : STD_ULOGIC := '0';
	VARIABLE PInfo_CLR    : VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation      : STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 5);
	VARIABLE CLK_delayed        : STD_ULOGIC := 'X';
	VARIABLE J_delayed        : STD_ULOGIC := 'X';
	VARIABLE K_delayed        : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_J_CLK_negedge,
	 TimingData		=> Tmkr_J_CLK_negedge,
	 TestSignal		=> J_ipd,
	 TestSignalName		=> "J",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_J_CLK_posedge_negedge,
	 SetupLow		=> tsetup_J_CLK_negedge_negedge,
	 HoldHigh		=> thold_J_CLK_posedge_negedge,
	 HoldLow		=> thold_J_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01((CLR_ipd)) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/JKF2B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_K_CLK_negedge,
	 TimingData             => Tmkr_K_CLK_negedge,
	 TestSignal             => K_ipd,
	 TestSignalName         => "K",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 SetupHigh              => tsetup_K_CLK_posedge_negedge,
	 SetupLow               => tsetup_K_CLK_negedge_negedge,
	 HoldHigh               => thold_K_CLK_posedge_negedge,
	 HoldLow                => thold_K_CLK_negedge_negedge,
	 CheckEnabled           =>  TO_X01((CLR_ipd)) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/JKF2B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_CLR_CLK_negedge,
	 TimingData		=> Tmkr_CLR_CLK_negedge,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_CLR_CLK_posedge_negedge,
	 Removal		=> thold_CLR_CLK_posedge_negedge,
	 ActiveLow              => TRUE,
	 CheckEnabled		=>  TRUE,
	 RefTransition          => 'F',
	 HeaderMsg              => InstancePath & "JKF2B",
	 Xon            => Xon,
	 MsgOn          => MsgOn,
	 MsgSeverity            => WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh => tpw_CLK_negedge,
	 PulseWidthLow => tpw_CLK_posedge,
	 CheckEnabled		=> TO_X01((CLR_ipd)) /= '0',
	 HeaderMsg		=> InstancePath & "JKF2B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData		=> PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> TRUE,
	 HeaderMsg		=> InstancePath & "JKF2B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

   -------------------------
   --  Functionality Section
   -------------------------

	 Violation := Tviol_J_CLK_negedge or 
	 Tviol_K_CLK_negedge or 
   Pviol_CLR or 
	 Pviol_CLK;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
	 StateTable => JKF2A_Q_tab,
	 DataIn => (
             CLR_ipd, CLK_ipd, K_delayed, J_delayed, Q_zd, CLK_delayed));
	 Q_zd := Violation XOR Q_zd;
	  --- now combinatorial logic input to the DFF 
	 J_delayed :=  J_ipd ;
          --- now combinatorial logic input to the DFF 
         K_delayed :=  (NOT K_ipd) ;
	 CLK_delayed := CLK_ipd;

	 ----------------------
	 --  Path Delay Section
	 ----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1 => (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_JKF2B_VITAL of JKF2B is
   for VITAL_ACT
   end for;
end CFG_JKF2B_VITAL;



 ---- CELL JKF3A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity JKF3A is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge   	:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        PRE	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of JKF3A :  entity is FALSE;
 end JKF3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of JKF3A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is FALSE;

	SIGNAL J_ipd  : STD_ULOGIC := 'X';
	SIGNAL K_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (J_ipd, J, tipd_J);
	VitalWireDelay (K_ipd, K, tipd_K);
	VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (J_ipd, K_ipd, PRE_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_J_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_J_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_K_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_K_CLK_posedge		:  VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_posedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_posedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK  : STD_ULOGIC := '0';
	VARIABLE PInfo_CLK  : VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE    : STD_ULOGIC := '0';
	VARIABLE PInfo_PRE    : VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation      : STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 5);
	VARIABLE CLK_delayed        : STD_ULOGIC := 'X';
	VARIABLE J_delayed        : STD_ULOGIC := 'X';
	VARIABLE K_delayed        : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_J_CLK_posedge,
	 TimingData		=> Tmkr_J_CLK_posedge,
	 TestSignal		=> J_ipd,
	 TestSignalName		=> "J",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_J_CLK_posedge_posedge,
	 SetupLow		=> tsetup_J_CLK_negedge_posedge,
	 HoldHigh		=> thold_J_CLK_posedge_posedge,
	 HoldLow		=> thold_J_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01((PRE_ipd)) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/JKF3A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_K_CLK_posedge,
	 TimingData             => Tmkr_K_CLK_posedge,
	 TestSignal             => K_ipd,
	 TestSignalName         => "K",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 SetupHigh              => tsetup_K_CLK_posedge_posedge,
	 SetupLow               => tsetup_K_CLK_negedge_posedge,
	 HoldHigh               => thold_K_CLK_posedge_posedge,
	 HoldLow                => thold_K_CLK_negedge_posedge,
	 CheckEnabled           =>  TO_X01((PRE_ipd)) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/JKF3A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_CLK_posedge,
	 TimingData		=> Tmkr_PRE_CLK_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay	=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_posedge,
	 Removal		=> thold_PRE_CLK_posedge_posedge,
	 ActiveLow		=> TRUE,
   CheckEnabled		=>   TRUE,
	 RefTransition		=> 'R',
	 HeaderMsg              => InstancePath & "JKF3A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh => tpw_CLK_posedge,
	 PulseWidthLow => tpw_CLK_negedge,
	 CheckEnabled		=> TO_X01((PRE_ipd)) /= '0',
	 HeaderMsg		=> InstancePath & "JKF3A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow		=> tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> TRUE, 
	 HeaderMsg		=> InstancePath & "JKF3A",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

   -------------------------
   --  Functionality Section
   -------------------------

	 Violation := Tviol_J_CLK_posedge or 
	 Tviol_K_CLK_posedge or 
   Tviol_PRE_CLK_posedge or 
	 Pviol_PRE or Pviol_CLK;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
   StateTable => JKF3A_Q_tab,
   DataIn => (
CLK_delayed, K_delayed, J_delayed, Q_zd, PRE_ipd, CLK_ipd));
	 Q_zd := Violation XOR Q_zd;
	  --- now combinatorial logic input to the DFF 
	 J_delayed :=  J_ipd ;
          --- now combinatorial logic input to the DFF 
         K_delayed :=  (NOT K_ipd) ;
	 CLK_delayed := CLK_ipd;

	 ----------------------
	 --  Path Delay Section
	 ----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1 => (PRE_ipd'last_event, tpd_PRE_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_JKF3A_VITAL of JKF3A is
   for VITAL_ACT
   end for;
end CFG_JKF3A_VITAL;



 ---- CELL JKF3B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity JKF3B is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge   	:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        PRE	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of JKF3B :  entity is FALSE;
 end JKF3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of JKF3B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is FALSE;

	SIGNAL J_ipd  : STD_ULOGIC := 'X';
	SIGNAL K_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (J_ipd, J, tipd_J);
	VitalWireDelay (K_ipd, K, tipd_K);
	VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (J_ipd, K_ipd, PRE_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_J_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_J_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_K_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_K_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_negedge         : STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_negedge         : VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK  : STD_ULOGIC := '0';
	VARIABLE PInfo_CLK  : VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE    : STD_ULOGIC := '0';
	VARIABLE PInfo_PRE    : VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation      : STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 5);
	VARIABLE CLK_delayed        : STD_ULOGIC := 'X';
	VARIABLE J_delayed        : STD_ULOGIC := 'X';
	VARIABLE K_delayed        : STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;

	begin

	------------------------
	--  Timing Check Section
	------------------------
	if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_J_CLK_negedge,
	 TimingData		=> Tmkr_J_CLK_negedge,
	 TestSignal		=> J_ipd,
	 TestSignalName		=> "J",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_J_CLK_posedge_negedge,
	 SetupLow		=> tsetup_J_CLK_negedge_negedge,
	 HoldHigh		=> thold_J_CLK_posedge_negedge,
	 HoldLow		=> thold_J_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01((PRE_ipd)) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/JKF3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalSetupHoldCheck (
	 Violation              => Tviol_K_CLK_negedge,
	 TimingData             => Tmkr_K_CLK_negedge,
	 TestSignal             => K_ipd,
	 TestSignalName         => "K",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 SetupHigh              => tsetup_K_CLK_posedge_negedge,
	 SetupLow               => tsetup_K_CLK_negedge_negedge,
	 HoldHigh               => thold_K_CLK_posedge_negedge,
	 HoldLow                => thold_K_CLK_negedge_negedge,
	 CheckEnabled           =>  TO_X01((PRE_ipd)) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/JKF3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation		=> Tviol_PRE_CLK_negedge,
	 TimingData		=> Tmkr_PRE_CLK_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay	=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_negedge,
	 Removal		=> thold_PRE_CLK_posedge_negedge,
	 ActiveLow		=> TRUE,
   CheckEnabled		=>   TRUE,
	 RefTransition		=> 'F',
	 HeaderMsg              => InstancePath & "JKF3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthHigh => tpw_CLK_negedge,
	 PulseWidthLow => tpw_CLK_posedge,
	 CheckEnabled		=> TO_X01((PRE_ipd)) /= '0',
	 HeaderMsg		=> InstancePath & "JKF3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow		=> tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> TRUE, 
	 HeaderMsg		=> InstancePath & "JKF3B",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

   end if;

   -------------------------
   --  Functionality Section
   -------------------------

	 Violation := Tviol_J_CLK_negedge or 
	 Tviol_K_CLK_negedge or 
   Tviol_PRE_CLK_negedge or Pviol_PRE or Pviol_CLK;

	VitalStateTable(
	 Result => Q_zd,
	 PreviousDataIn => PrevData_Q,
   StateTable => JKF3A_Q_tab,
   DataIn => (
CLK_ipd, K_delayed, J_delayed, Q_zd, PRE_ipd, CLK_delayed));
	 Q_zd := Violation XOR Q_zd;
	  --- now combinatorial logic input to the DFF 
	 J_delayed :=  J_ipd ;
          --- now combinatorial logic input to the DFF 
         K_delayed :=  (NOT K_ipd) ;
	 CLK_delayed := CLK_ipd;

	 ----------------------
	 --  Path Delay Section
	 ----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1 => (PRE_ipd'last_event, tpd_PRE_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);


 end process;

end VITAL_ACT;

configuration CFG_JKF3B_VITAL of JKF3B is
   for VITAL_ACT
   end for;
end CFG_JKF3B_VITAL;



 ---- CELL MAJ3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MAJ3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MAJ3 :  entity is TRUE;
 end MAJ3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MAJ3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) OR ( B_ipd  AND  C_ipd )) OR ( A_ipd  AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MAJ3_VITAL of MAJ3 is 
    for VITAL_ACT
    end for;
 end CFG_MAJ3_VITAL;



 ---- CELL MAJ3X ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MAJ3X is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MAJ3X :  entity is TRUE;
 end MAJ3X;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MAJ3X is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( A_ipd  AND  B_ipd ),( (NOT A_ipd)  AND  B_ipd ), (NOT C_ipd) ) OR (( A_ipd  AND  (NOT B_ipd) ) AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MAJ3X_VITAL of MAJ3X is 
    for VITAL_ACT
    end for;
 end CFG_MAJ3X_VITAL;



 ---- CELL MAJ3XI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MAJ3XI is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MAJ3XI :  entity is TRUE;
 end MAJ3XI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MAJ3XI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT (  VitalMUX2(( A_ipd  AND  B_ipd ),( (NOT A_ipd)  AND  B_ipd ), (NOT C_ipd) ) OR (( A_ipd  AND  (NOT B_ipd) ) AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MAJ3XI_VITAL of MAJ3XI is 
    for VITAL_ACT
    end for;
 end CFG_MAJ3XI_VITAL;



 ---- CELL MIN3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MIN3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MIN3 :  entity is TRUE;
 end MIN3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MIN3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) OR ( (NOT A_ipd)  AND  (NOT C_ipd) )) OR ( (NOT B_ipd)  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MIN3_VITAL of MIN3 is 
    for VITAL_ACT
    end for;
 end CFG_MIN3_VITAL;



 ---- CELL MIN3X ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MIN3X is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MIN3X :  entity is TRUE;
 end MIN3X;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MIN3X is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( A_ipd  AND  (NOT B_ipd) ),( (NOT A_ipd)  AND  (NOT B_ipd) ), (NOT C_ipd) ) OR (( (NOT A_ipd)  AND  B_ipd ) AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MIN3X_VITAL of MIN3X is 
    for VITAL_ACT
    end for;
 end CFG_MIN3X_VITAL;



 ---- CELL MIN3XI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MIN3XI is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MIN3XI :  entity is TRUE;
 end MIN3XI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MIN3XI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT (  VitalMUX2(( A_ipd  AND  (NOT B_ipd) ),( (NOT A_ipd)  AND  (NOT B_ipd) ), (NOT C_ipd) ) OR (( (NOT A_ipd)  AND  B_ipd ) AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MIN3XI_VITAL of MIN3XI is 
    for VITAL_ACT
    end for;
 end CFG_MIN3XI_VITAL;



 ---- CELL MX2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MX2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MX2 :  entity is TRUE;
 end MX2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MX2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL S_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (S_ipd, S, tipd_S);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, S_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( A_ipd , B_ipd , (NOT S_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (S_ipd'last_event,tpd_S_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MX2_VITAL of MX2 is 
    for VITAL_ACT
    end for;
 end CFG_MX2_VITAL;



 ---- CELL MX2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MX2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MX2A :  entity is TRUE;
 end MX2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MX2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL S_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (S_ipd, S, tipd_S);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, S_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( (NOT A_ipd) , B_ipd , (NOT S_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (S_ipd'last_event,tpd_S_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MX2A_VITAL of MX2A is 
    for VITAL_ACT
    end for;
 end CFG_MX2A_VITAL;



 ---- CELL MX2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MX2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MX2B :  entity is TRUE;
 end MX2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MX2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL S_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (S_ipd, S, tipd_S);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, S_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( A_ipd , (NOT B_ipd) , (NOT S_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (S_ipd'last_event,tpd_S_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MX2B_VITAL of MX2B is 
    for VITAL_ACT
    end for;
 end CFG_MX2B_VITAL;



 ---- CELL MX2C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MX2C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MX2C :  entity is TRUE;
 end MX2C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MX2C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL S_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (S_ipd, S, tipd_S);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, S_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( (NOT A_ipd) , (NOT B_ipd) , (NOT S_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (S_ipd'last_event,tpd_S_Y, true),
	             2 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MX2C_VITAL of MX2C is 
    for VITAL_ACT
    end for;
 end CFG_MX2C_VITAL;



 ---- CELL MX4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity MX4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S0		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S1		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of MX4 :  entity is TRUE;
 end MX4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of MX4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S0_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S1_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S0_ipd, S0, tipd_S0);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S1_ipd, S1, tipd_S1);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S0_ipd, D1_ipd, S1_ipd, D2_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , (NOT S0_ipd) ), VitalMUX2( D2_ipd , D3_ipd , (NOT S0_ipd) ), (NOT S1_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S0_ipd'last_event,tpd_S0_Y, true),
	             2 => (D1_ipd'last_event,tpd_D1_Y, true),
	             3 => (S1_ipd'last_event,tpd_S1_Y, true),
	             4 => (D2_ipd'last_event,tpd_D2_Y, true),
	             5 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_MX4_VITAL of MX4 is 
    for VITAL_ACT
    end for;
 end CFG_MX4_VITAL;



 ---- CELL NAND2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND2 :  entity is TRUE;
 end NAND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT (  A_ipd  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND2_VITAL of NAND2 is 
    for VITAL_ACT
    end for;
 end CFG_NAND2_VITAL;



 ---- CELL NAND2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND2A :  entity is TRUE;
 end NAND2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT (  (NOT A_ipd)  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND2A_VITAL of NAND2A is 
    for VITAL_ACT
    end for;
 end CFG_NAND2A_VITAL;



 ---- CELL NAND2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND2B :  entity is TRUE;
 end NAND2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT (  (NOT A_ipd)  AND  (NOT B_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND2B_VITAL of NAND2B is 
    for VITAL_ACT
    end for;
 end CFG_NAND2B_VITAL;



 ---- CELL NAND3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND3 :  entity is TRUE;
 end NAND3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND3_VITAL of NAND3 is 
    for VITAL_ACT
    end for;
 end CFG_NAND3_VITAL;



 ---- CELL NAND3A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND3A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND3A :  entity is TRUE;
 end NAND3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND3A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND3A_VITAL of NAND3A is 
    for VITAL_ACT
    end for;
 end CFG_NAND3A_VITAL;



 ---- CELL NAND3B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND3B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND3B :  entity is TRUE;
 end NAND3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND3B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND3B_VITAL of NAND3B is 
    for VITAL_ACT
    end for;
 end CFG_NAND3B_VITAL;



 ---- CELL NAND3C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND3C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND3C :  entity is TRUE;
 end NAND3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND3C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND3C_VITAL of NAND3C is 
    for VITAL_ACT
    end for;
 end CFG_NAND3C_VITAL;



 ---- CELL NAND4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND4 :  entity is TRUE;
 end NAND4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  OR  (NOT B_ipd) ) OR  (NOT C_ipd) ) OR  (NOT D_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND4_VITAL of NAND4 is 
    for VITAL_ACT
    end for;
 end CFG_NAND4_VITAL;



 ---- CELL NAND4A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND4A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND4A :  entity is TRUE;
 end NAND4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND4A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND4A_VITAL of NAND4A is 
    for VITAL_ACT
    end for;
 end CFG_NAND4A_VITAL;



 ---- CELL NAND4B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND4B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND4B :  entity is TRUE;
 end NAND4B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND4B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND4B_VITAL of NAND4B is 
    for VITAL_ACT
    end for;
 end CFG_NAND4B_VITAL;



 ---- CELL NAND4C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND4C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND4C :  entity is TRUE;
 end NAND4C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND4C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND4C_VITAL of NAND4C is 
    for VITAL_ACT
    end for;
 end CFG_NAND4C_VITAL;



 ---- CELL NAND4D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND4D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND4D :  entity is TRUE;
 end NAND4D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND4D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) AND  (NOT D_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND4D_VITAL of NAND4D is 
    for VITAL_ACT
    end for;
 end CFG_NAND4D_VITAL;



 ---- CELL NAND5B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND5B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND5B :  entity is TRUE;
 end NAND5B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND5B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd ) AND  D_ipd ) AND  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND5B_VITAL of NAND5B is 
    for VITAL_ACT
    end for;
 end CFG_NAND5B_VITAL;



 ---- CELL NAND5C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NAND5C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NAND5C :  entity is TRUE;
 end NAND5C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NAND5C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) AND  D_ipd ) AND  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NAND5C_VITAL of NAND5C is 
    for VITAL_ACT
    end for;
 end CFG_NAND5C_VITAL;



 ---- CELL NOR2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR2 :  entity is TRUE;
 end NOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT (  A_ipd  OR  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR2_VITAL of NOR2 is 
    for VITAL_ACT
    end for;
 end CFG_NOR2_VITAL;



 ---- CELL NOR2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR2A :  entity is TRUE;
 end NOR2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT (  (NOT A_ipd)  OR  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR2A_VITAL of NOR2A is 
    for VITAL_ACT
    end for;
 end CFG_NOR2A_VITAL;



 ---- CELL NOR2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR2B :  entity is TRUE;
 end NOR2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT (  (NOT A_ipd)  OR  (NOT B_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR2B_VITAL of NOR2B is 
    for VITAL_ACT
    end for;
 end CFG_NOR2B_VITAL;



 ---- CELL NOR3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR3 :  entity is TRUE;
 end NOR3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  OR  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR3_VITAL of NOR3 is 
    for VITAL_ACT
    end for;
 end CFG_NOR3_VITAL;



 ---- CELL NOR3A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR3A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR3A :  entity is TRUE;
 end NOR3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR3A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  OR  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR3A_VITAL of NOR3A is 
    for VITAL_ACT
    end for;
 end CFG_NOR3A_VITAL;



 ---- CELL NOR3B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR3B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR3B :  entity is TRUE;
 end NOR3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR3B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  OR  (NOT B_ipd) ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR3B_VITAL of NOR3B is 
    for VITAL_ACT
    end for;
 end CFG_NOR3B_VITAL;



 ---- CELL NOR3C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR3C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR3C :  entity is TRUE;
 end NOR3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR3C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  OR  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR3C_VITAL of NOR3C is 
    for VITAL_ACT
    end for;
 end CFG_NOR3C_VITAL;



 ---- CELL NOR4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR4 :  entity is TRUE;
 end NOR4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) AND  (NOT D_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR4_VITAL of NOR4 is 
    for VITAL_ACT
    end for;
 end CFG_NOR4_VITAL;



 ---- CELL NOR4A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR4A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR4A :  entity is TRUE;
 end NOR4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR4A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  OR  B_ipd ) OR  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR4A_VITAL of NOR4A is 
    for VITAL_ACT
    end for;
 end CFG_NOR4A_VITAL;



 ---- CELL NOR4B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR4B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR4B :  entity is TRUE;
 end NOR4B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR4B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  OR  (NOT B_ipd) ) OR  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR4B_VITAL of NOR4B is 
    for VITAL_ACT
    end for;
 end CFG_NOR4B_VITAL;



 ---- CELL NOR4C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR4C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR4C :  entity is TRUE;
 end NOR4C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR4C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  OR  (NOT B_ipd) ) OR  (NOT C_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR4C_VITAL of NOR4C is 
    for VITAL_ACT
    end for;
 end CFG_NOR4C_VITAL;



 ---- CELL NOR4D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR4D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR4D :  entity is TRUE;
 end NOR4D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR4D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  OR  (NOT B_ipd) ) OR  (NOT C_ipd) ) OR  (NOT D_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR4D_VITAL of NOR4D is 
    for VITAL_ACT
    end for;
 end CFG_NOR4D_VITAL;



 ---- CELL NOR5B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR5B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR5B :  entity is TRUE;
 end NOR5B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR5B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ((( (NOT A_ipd)  OR  (NOT B_ipd) ) OR  C_ipd ) OR  D_ipd ) OR  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR5B_VITAL of NOR5B is 
    for VITAL_ACT
    end for;
 end CFG_NOR5B_VITAL;



 ---- CELL NOR5C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity NOR5C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of NOR5C :  entity is TRUE;
 end NOR5C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of NOR5C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ((( (NOT A_ipd)  OR  (NOT B_ipd) ) OR  (NOT C_ipd) ) OR  D_ipd ) OR  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_NOR5C_VITAL of NOR5C is 
    for VITAL_ACT
    end for;
 end CFG_NOR5C_VITAL;



 ---- CELL OA1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA1 :  entity is TRUE;
 end OA1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of OA1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  OR  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA1_VITAL of OA1 is 
    for VITAL_ACT
    end for;
 end CFG_OA1_VITAL;



 ---- CELL OA1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA1A :  entity is TRUE;
 end OA1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of OA1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  OR  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA1A_VITAL of OA1A is 
    for VITAL_ACT
    end for;
 end CFG_OA1A_VITAL;



 ---- CELL OA1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA1B :  entity is TRUE;
 end OA1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of OA1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  OR  B_ipd ) AND  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA1B_VITAL of OA1B is 
    for VITAL_ACT
    end for;
 end CFG_OA1B_VITAL;



 ---- CELL OA1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA1C :  entity is TRUE;
 end OA1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of OA1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  OR  B_ipd ) AND  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA1C_VITAL of OA1C is 
    for VITAL_ACT
    end for;
 end CFG_OA1C_VITAL;



 ---- CELL OA2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA2 :  entity is TRUE;
 end OA2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of OA2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  OR  B_ipd ) AND ( C_ipd  OR  D_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA2_VITAL of OA2 is 
    for VITAL_ACT
    end for;
 end CFG_OA2_VITAL;



 ---- CELL OA2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA2A :  entity is TRUE;
 end OA2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of OA2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  OR  B_ipd ) AND ( C_ipd  OR  D_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA2A_VITAL of OA2A is 
    for VITAL_ACT
    end for;
 end CFG_OA2A_VITAL;



 ---- CELL OA3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity OA3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of OA3 :  entity is TRUE;
 end OA3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library a54sxa;
use a54sxa.VTABLES.all;

architecture VITAL_ACT of OA3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  OR  B_ipd ) AND  C_ipd ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_OA3_VITAL of O